/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v80;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SSBViewDB2v80
extends AbstractSSBDB2 {
    private StorageDesignDB2v80 storageDesign;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof TableView && ((TableView)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof TableViewProxyDB2 && ((TableViewProxyDB2)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        TableView view = null;
        TableViewProxyDB2 proxy = null;
        if (object instanceof TableView) {
            view = (TableView)object;
            if (this.getStorageDesign(object) instanceof StorageDesignDB2v80) {
                this.storageDesign = (StorageDesignDB2v80)this.getStorageDesign(object);
                proxy = (TableViewProxyDB2)this.storageDesign.getProxy(view);
            }
        } else {
            proxy = (TableViewProxyDB2)object;
            view = (TableView)proxy.getObject();
            this.storageDesign = (StorageDesignDB2v80)this.getStorageDesign(object);
        }
        if (!view.isValidSQL()) {
            SSBViewDB2v80.appendStringWithSpace(buffer, "--  ERROR: Invalid View " + view.getName());
            DDLFileMaker.incrementErrors();
            SSBViewDB2v80.appendNewLine(buffer, prettyPrint, 0);
            SSBViewDB2v80.appendNewLine(buffer, prettyPrint, 0);
            return;
        }
        if (proxy != null) {
            this.appendBeforeCreateScript(buffer, prettyPrint, view);
            if (proxy.isCommentChanged()) {
                this.appendComment(buffer, proxy);
            } else {
                this.appendComment(buffer, view);
            }
            Object stmt = proxy.getDefinition();
            stmt = ((String)stmt).trim();
            if (((String)stmt).endsWith(";")) {
                stmt = ((String)stmt).substring(0, ((String)stmt).length() - 1).trim();
            }
            if (!"".equalsIgnoreCase((String)stmt)) {
                int index;
                Object createViewPart = "";
                boolean includesColumnList = false;
                if (Token.getFirstToken((String)stmt).equalsIgnoreCase("CREATE") && (index = StringUtilities.indexOf((String)stmt, "VIEW")) > -1) {
                    int viewNameIndex;
                    int dotIndex;
                    createViewPart = ((String)stmt).substring(0, index + 4);
                    String stmtWithoutNL = ((String)(stmt = ((String)stmt).substring(index + 4).trim())).replaceAll("[\t\n\f\r\u000b]+", " ");
                    String oldViewName = Token.getFirstName(stmtWithoutNL, '\"', '\"');
                    int bracketIndex = oldViewName.indexOf(40);
                    if (bracketIndex > -1) {
                        oldViewName = oldViewName.substring(0, bracketIndex);
                    }
                    if ((dotIndex = oldViewName.indexOf(46)) > -1) {
                        oldViewName = oldViewName.substring(dotIndex + 1);
                    }
                    if ((viewNameIndex = ((String)stmt).indexOf(oldViewName, dotIndex)) > -1 && ((String)(stmt = ((String)stmt).substring(viewNameIndex + oldViewName.length()))).startsWith("\"")) {
                        stmt = ((String)stmt).substring(1);
                    }
                    if (((String)(stmt = ((String)stmt).trim())).toUpperCase().startsWith("AS")) {
                        stmt = ((String)stmt).substring(2).trim();
                    } else if (((String)stmt).startsWith("(")) {
                        includesColumnList = true;
                    }
                }
                if (!Token.startsWithString((String)createViewPart, "CREATE")) {
                    createViewPart = "CREATE VIEW";
                }
                String longName = this.storageDesign.isOpen() ? proxy.getLongNameDDL() : view.getLongNameDDL();
                createViewPart = (String)createViewPart + " " + this.storageDesign.getFormatedName(longName);
                if (includesColumnList) {
                    stmt = (String)createViewPart + " " + (String)stmt;
                } else if (view.isGenerateHeaderInDDL()) {
                    String columnList = this.getColumnList(view);
                    stmt = (String)createViewPart + " " + columnList + " AS" + NEWLINE + (String)stmt;
                } else {
                    stmt = (String)createViewPart + " AS" + NEWLINE + (String)stmt;
                }
                SSBViewDB2v80.appendStringWithSpace(buffer, (String)stmt);
                this.appendCheckOption(buffer, proxy, prettyPrint);
                SSBViewDB2v80.appendNewLine(buffer, prettyPrint, 0);
                SSBViewDB2v80.appendLineFinisher(buffer, prettyPrint);
                DDLFileMaker.incrementCreateView();
                this.appendAfterCreateScript(buffer, prettyPrint, view);
                if (view.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendViewCommentOn(this.storageDesign, buffer, view, proxy, prettyPrint);
                }
                this.appendLabelOn(buffer, proxy, prettyPrint);
            } else {
                SSBViewDB2v80.appendStringWithSpace(buffer, "--  ERROR: Invalid View " + view.getName() + " with empty body");
                DDLFileMaker.incrementErrors();
            }
        } else {
            if (view.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendViewCommentOn(this.storageDesign, buffer, view, proxy, prettyPrint);
            }
            DDLFileMaker.incrementCreateView();
        }
    }

    protected String appendOwner(String definition, TableViewProxyDB2 view) {
        String result = definition;
        String name = Token.getTokenAfter(result, "VIEW");
        if (name.indexOf(46) == -1 && view.getOwner() != null && !view.getOwner().getName().equalsIgnoreCase("[Implicit]") && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            String owner = this.storageDesign.getFormatedName(view.getOwner().getName());
            result = this.appendOwner(result, name, owner);
        }
        return result;
    }

    protected void appendCheckOption(StringBuffer buffer, TableViewProxyDB2 tableViewProxy, boolean prettyPrint) {
        String checkOptionClause;
        if (!tableViewProxy.getDefinition().equalsIgnoreCase("") && tableViewProxy.getCheckOption() && buffer.indexOf(checkOptionClause = "WITH " + tableViewProxy.getCheckOptionScope() + " CHECK OPTION") == -1) {
            SSBViewDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBViewDB2v80.appendStringWithSpace(buffer, checkOptionClause);
        }
    }

    private void appendLabelOn(StringBuffer buffer, TableViewProxyDB2 viewProxy, boolean prettyPrint) {
        if (!viewProxy.getLabelOn().equalsIgnoreCase("")) {
            SSBViewDB2v80.appendStringWithSpace(buffer, "LABEL");
            SSBViewDB2v80.appendStringWithSpace(buffer, "ON");
            SSBViewDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(viewProxy.getLongNameDDL()));
            SSBViewDB2v80.appendStringWithSpace(buffer, "IS");
            SSBViewDB2v80.appendStringWithSpace(buffer, "'" + viewProxy.getLabelOn() + "'");
            SSBViewDB2v80.appendLineFinisher(buffer, prettyPrint);
        }
    }
}

