/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v70;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.TriggerDB2;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTriggerDB2v70
extends AbstractSSBDB2 {
    private AbstractStorageDesignDB2 storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        TriggerDB2 trigger = (TriggerDB2)object;
        this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(trigger);
        this.appendComment(buffer, trigger);
        this.appendCreate(buffer, trigger);
        this.appendTriggeringTime(buffer, trigger, prettyPrint);
        this.appendAction(buffer, trigger);
        this.appendOnTable(buffer, trigger);
        this.appendReferencing(buffer, trigger, prettyPrint);
        this.appendScope(buffer, trigger, prettyPrint);
        this.appendCondition(buffer, trigger, prettyPrint);
        this.appendTriggeredAction(buffer, trigger, prettyPrint);
        SSBTriggerDB2v70.appendNewLine(buffer, prettyPrint, 0);
        SSBTriggerDB2v70.appendLineFinisher(buffer, prettyPrint);
        DDLFileMaker.incrementCreateTrigger();
        if (trigger.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendCommentOn(buffer, trigger, prettyPrint);
        }
    }

    private void appendCommentOn(StringBuffer buffer, TriggerDB2 trigger, boolean prettyPrint) {
        SSBTriggerDB2v70.appendNewLine(buffer, prettyPrint, 0);
        SSBTriggerDB2v70.appendStringWithSpace(buffer, "COMMENT ON");
        SSBTriggerDB2v70.appendStringWithSpace(buffer, "TRIGGER");
        SSBTriggerDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(trigger.getLongNameDDL()));
        SSBTriggerDB2v70.appendStringWithSpace(buffer, "IS");
        SSBTriggerDB2v70.appendString(buffer, '\'');
        SSBTriggerDB2v70.appendString(buffer, trigger.getCommentInRDBMS());
        SSBTriggerDB2v70.appendStringWithSpace(buffer, '\'');
        SSBTriggerDB2v70.appendNewLine(buffer, prettyPrint, 0);
        SSBTriggerDB2v70.appendLineFinisher(buffer, prettyPrint);
    }

    private void appendCreate(StringBuffer buffer, TriggerDB2 trigger) {
        this.appendCreate(buffer);
        SSBTriggerDB2v70.appendStringWithSpace(buffer, "TRIGGER");
        if (trigger.getOwner() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            SSBTriggerDB2v70.appendString(buffer, this.storageDesign.getFormatedName(trigger.getOwner().getName()));
            SSBTriggerDB2v70.appendString(buffer, ".");
        }
        SSBTriggerDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(trigger.getName()));
    }

    private void appendTriggeringTime(StringBuffer buffer, TriggerDB2 trigger, boolean prettyPrint) {
        SSBTriggerDB2v70.appendNewLine(buffer, prettyPrint, 1);
        SSBTriggerDB2v70.appendStringWithSpace(buffer, trigger.getTriggerTime());
    }

    private void appendAction(StringBuffer buffer, TriggerDB2 trigger) {
        SSBTriggerDB2v70.appendStringWithSpace(buffer, trigger.getActions());
        if (trigger.getActions().equalsIgnoreCase(Trigger.ACTION_TYPES[1]) && !trigger.getColumns().equalsIgnoreCase("")) {
            SSBTriggerDB2v70.appendStringWithSpace(buffer, "OF");
            SSBTriggerDB2v70.appendStringWithSpace(buffer, trigger.getColumns());
        }
    }

    private void appendOnTable(StringBuffer buffer, TriggerDB2 trigger) {
        SSBTriggerDB2v70.appendStringWithSpace(buffer, "ON");
        SSBTriggerDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(trigger.getTable().getName()));
    }

    private void appendReferencing(StringBuffer buffer, TriggerDB2 trigger, boolean prettyPrint) {
        if (!(trigger.getRef_NEW_AS().equalsIgnoreCase("") && trigger.getRef_OLD_AS().equalsIgnoreCase("") && trigger.getNEW_TABLE_AS().equalsIgnoreCase("") && trigger.getOLD_TABLE_AS().equalsIgnoreCase(""))) {
            SSBTriggerDB2v70.appendStringWithSpace(buffer, "REFERENCING");
            if (!trigger.getRef_NEW_AS().equalsIgnoreCase("")) {
                SSBTriggerDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBTriggerDB2v70.appendStringWithSpace(buffer, "NEW");
                SSBTriggerDB2v70.appendStringWithSpace(buffer, "AS");
                SSBTriggerDB2v70.appendStringWithSpace(buffer, trigger.getRef_NEW_AS());
            }
            if (!trigger.getRef_OLD_AS().equalsIgnoreCase("")) {
                SSBTriggerDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBTriggerDB2v70.appendStringWithSpace(buffer, "OLD");
                SSBTriggerDB2v70.appendStringWithSpace(buffer, "AS");
                SSBTriggerDB2v70.appendStringWithSpace(buffer, trigger.getRef_OLD_AS());
            }
            if (!trigger.getOLD_TABLE_AS().equalsIgnoreCase("")) {
                SSBTriggerDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBTriggerDB2v70.appendStringWithSpace(buffer, "OLD TABLE");
                SSBTriggerDB2v70.appendStringWithSpace(buffer, "AS");
                SSBTriggerDB2v70.appendStringWithSpace(buffer, trigger.getOLD_TABLE_AS());
            }
            if (!trigger.getNEW_TABLE_AS().equalsIgnoreCase("")) {
                SSBTriggerDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBTriggerDB2v70.appendStringWithSpace(buffer, "NEW TABLE");
                SSBTriggerDB2v70.appendStringWithSpace(buffer, "AS");
                SSBTriggerDB2v70.appendStringWithSpace(buffer, trigger.getNEW_TABLE_AS());
            }
        }
    }

    private void appendScope(StringBuffer buffer, TriggerDB2 trigger, boolean prettyPrint) {
        SSBTriggerDB2v70.appendNewLine(buffer, prettyPrint, 1);
        SSBTriggerDB2v70.appendStringWithSpace(buffer, trigger.getScope());
        if (trigger.isScopeForEachRow()) {
            this.appendMode(buffer);
        }
    }

    private void appendMode(StringBuffer buffer) {
        SSBTriggerDB2v70.appendStringWithSpace(buffer, "MODE DB2SQL");
    }

    private void appendCondition(StringBuffer buffer, TriggerDB2 trigger, boolean prettyPrint) {
        if (!trigger.getCondition().equalsIgnoreCase("")) {
            SSBTriggerDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTriggerDB2v70.appendStringWithSpace(buffer, "WHEN");
            SSBTriggerDB2v70.appendStringWithSpace(buffer, '(');
            SSBTriggerDB2v70.appendStringWithSpace(buffer, trigger.getCondition());
            SSBTriggerDB2v70.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendTriggeredAction(StringBuffer buffer, TriggerDB2 trigger, boolean prettyPrint) {
        SSBTriggerDB2v70.appendNewLine(buffer, prettyPrint, 1);
        if (trigger.getBody().equalsIgnoreCase("")) {
            SSBTriggerDB2v70.appendStringWithSpace(buffer, "-- Empty body");
        } else {
            SSBTriggerDB2v70.appendStringWithSpace(buffer, trigger.getBody());
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TriggerDB2 && ((TriggerDB2)object).isMarkedGenerate() && ((TriggerDB2)object).getTable() != null;
    }
}

