/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v70;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBFKeyDB2v70
extends AbstractSSBDB2 {
    AbstractStorageDesignDB2 storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        KeyObject index = object instanceof FKIndexAssociation ? ((FKIndexAssociation)object).getLocalFKIndex() : (Index)object;
        this.storageDesign = (AbstractStorageDesignDB2)((RelationalDesign)index.getDesignPart()).getStorageDesign();
        this.appendFKDefinition(buffer, index, prettyPrint);
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index && ((Index)object).isFK()) {
            FKIndexAssociation fk = ((Index)object).getFKAssociation();
            if (fk.isMarkedGenerate()) {
                return true;
            }
        } else if (object instanceof FKIndexAssociation) {
            return ((FKIndexAssociation)object).isMarkedGenerate();
        }
        return false;
    }

    private StorageObject getOwner(FKContainer table) {
        TableProxyDB2 tableProxy = null;
        tableProxy = (TableProxyDB2)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (tableProxy != null && tableProxy.getOwner() != null && !tableProxy.getOwner().getName().equalsIgnoreCase("[Implicit]")) {
            return tableProxy.getOwner();
        }
        return null;
    }

    private void appendFKDefinition(StringBuffer buffer, KeyObject index, boolean prettyPrint) {
        FKIndexAssociation fkassociation = index.getFKAssociation();
        KeyObject foreignKey = fkassociation.getLocalFKIndex();
        if (foreignKey != null && fkassociation.getRemoteTable() instanceof Table) {
            Column[] columns = (Column[])foreignKey.getElements();
            if (columns != null && columns.length > 0) {
                SSBFKeyDB2v70.appendNewLine(buffer, prettyPrint, 0);
                this.appendBeforeAlterScript(buffer, prettyPrint, fkassociation.getTable());
                SSBFKeyDB2v70.appendStringWithSpace(buffer, "ALTER");
                SSBFKeyDB2v70.appendStringWithSpace(buffer, "TABLE");
                StorageObject owner = this.getOwner(fkassociation.getTable());
                if (owner != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
                    SSBFKeyDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(owner.getName()) + "." + this.storageDesign.getFormatedName(fkassociation.getTable().getName()));
                } else {
                    SSBFKeyDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fkassociation.getTable().getName()));
                }
                SSBFKeyDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBFKeyDB2v70.appendStringWithSpace(buffer, "ADD");
                SSBFKeyDB2v70.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBFKeyDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fkassociation.getName()));
                SSBFKeyDB2v70.appendStringWithSpace(buffer, "FOREIGN KEY");
                SSBFKeyDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBFKeyDB2v70.appendStringWithSpace(buffer, '(');
                for (int i = 0; i < columns.length; ++i) {
                    SSBFKeyDB2v70.appendNewLine(buffer, prettyPrint, 1);
                    SSBFKeyDB2v70.appendString(buffer, ' ');
                    SSBFKeyDB2v70.appendString(buffer, this.storageDesign.getFormatedName(columns[i].getName()));
                    if (i >= columns.length - 1) continue;
                    this.appendComma(buffer);
                }
                SSBFKeyDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBFKeyDB2v70.appendStringWithSpace(buffer, ')');
                SSBFKeyDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBFKeyDB2v70.appendStringWithSpace(buffer, "REFERENCES");
                owner = this.getOwner(fkassociation.getRemoteTable());
                if (owner != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
                    SSBFKeyDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(owner.getName()) + "." + this.storageDesign.getFormatedName(fkassociation.getRemoteTable().getName()));
                } else {
                    SSBFKeyDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fkassociation.getRemoteTable().getName()));
                }
                KeyObject remoteIndex = fkassociation.getRemoteIndex();
                Column[] refColumns = (Column[])remoteIndex.getElements();
                SSBFKeyDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBFKeyDB2v70.appendStringWithSpace(buffer, '(');
                SSBFKeyDB2v70.appendNewLine(buffer, prettyPrint, 1);
                for (int i = 0; i < refColumns.length; ++i) {
                    SSBFKeyDB2v70.appendString(buffer, ' ');
                    SSBFKeyDB2v70.appendString(buffer, this.storageDesign.getFormatedName(refColumns[i].getName()));
                    if (i != refColumns.length - 1) {
                        this.appendComma(buffer);
                    }
                    SSBFKeyDB2v70.appendNewLine(buffer, prettyPrint, 1);
                }
                SSBFKeyDB2v70.appendStringWithSpace(buffer, ')');
                this.appendOnDelete(buffer, fkassociation, prettyPrint);
                SSBFKeyDB2v70.appendNewLine(buffer, prettyPrint, 0);
                SSBFKeyDB2v70.appendLineFinisher(buffer, prettyPrint);
                SSBFKeyDB2v70.appendNewLine(buffer, prettyPrint, 0);
                DDLFileMaker.incrementAlterTable();
                this.appendAfterAlterScript(buffer, prettyPrint, fkassociation.getTable());
            } else {
                SSBFKeyDB2v70.appendNewLine(buffer, prettyPrint, 0);
                buffer.append("-- Error - Foreign Key ");
                buffer.append(this.storageDesign.getFormatedName(fkassociation.getContainerWithKeyObject().getName()) + "." + this.storageDesign.getFormatedName(fkassociation.getName()));
                buffer.append(" has no columns");
                SSBFKeyDB2v70.appendNewLine(buffer, prettyPrint, 0);
                DDLFileMaker.incrementErrors();
            }
        }
    }

    private void appendOnDelete(StringBuffer buffer, FKIndexAssociation fk, boolean prettyPrint) {
        String onDelete = fk.getDeleteRule();
        if (onDelete.equalsIgnoreCase("SET DEFAULT")) {
            onDelete = fk.isMandatory() ? "RESTRICT" : "SET NULL";
        }
        SSBFKeyDB2v70.appendNewLine(buffer, prettyPrint, 1);
        SSBFKeyDB2v70.appendStringWithSpace(buffer, "ON");
        SSBFKeyDB2v70.appendStringWithSpace(buffer, "DELETE");
        SSBFKeyDB2v70.appendStringWithSpace(buffer, onDelete);
    }
}

