/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;

public class EHNotes
extends ExportHandler {
    public EHNotes(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("ObjectID").append(",");
        sb.append("NumOID").append(",");
        sb.append("Type").append(",");
        sb.append("Sequence").append(",");
        sb.append("Text");
        lines.add(sb.toString());
        for (CSVExporter.ObjDesc objDesc : this.getCsvExporter().getNotes()) {
            String text = this.replaceString(objDesc.getText());
            if ("".equalsIgnoreCase(text)) continue;
            int seq = 0;
            while (text.length() > 2000) {
                ++seq;
                String t1 = text.substring(0, 2000);
                int bytes = 2000;
                try {
                    bytes = t1.getBytes("UTF-8").length;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (bytes > 2000) {
                    int diff = bytes - 2000;
                    t1 = text.substring(0, 2000 - diff);
                    text = text.substring(2000 - diff);
                } else {
                    text = text.substring(2000);
                }
                sb = new StringBuffer();
                sb.append(objDesc.getObjectID()).append(",");
                sb.append(objDesc.getNumOID()).append(",");
                sb.append(objDesc.getType()).append(",");
                sb.append(seq).append(",");
                sb.append(this.quotedString(t1)).append(",");
                lines.add(sb.toString());
            }
            if (text.length() <= 0) continue;
            ++seq;
            sb = new StringBuffer();
            sb.append(objDesc.getObjectID()).append(",");
            sb.append(objDesc.getNumOID()).append(",");
            sb.append(objDesc.getType()).append(",");
            sb.append(seq).append(",");
            sb.append(this.quotedString(text)).append(",");
            lines.add(sb.toString());
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_Notes.csv";
    }
}

