/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;

public class EHEntityView
extends ExportHandler {
    public EHEntityView(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("EntityView_Name").append(",");
        sb.append("ObjectID").append(",");
        sb.append("NumOID").append(",");
        sb.append("ImportID").append(",");
        sb.append("ModelID").append(",");
        sb.append("Num_ModelID").append(",");
        sb.append("Structured_Type_ID").append(",");
        sb.append("Num_Structured_Type_ID").append(",");
        sb.append("Structured_Type_Name").append(",");
        sb.append("User_Defined").append(",");
        sb.append("View_Type");
        lines.add(sb.toString());
        LogicalDesign logDesign = this.getDesign().getLogicalDesign();
        if (this.getCsvExporter().isModelSelected(logDesign)) {
            Iterator it = logDesign.getEntityViewSet().iterator();
            while (it.hasNext()) {
                EntityView entityView = (EntityView)it.next();
                sb = new StringBuffer();
                sb.append(this.replaceAndQuoteString(entityView.getName())).append(",");
                sb.append(entityView.getObjectID()).append(",");
                sb.append(entityView.getNumID()).append(",");
                sb.append(entityView.getImportedId() != null ? entityView.getImportedId() : "").append(",");
                sb.append(logDesign.getObjectID()).append(",");
                sb.append(logDesign.getNumID()).append(",");
                if (entityView.isBST()) {
                    sb.append(entityView.getBasedOnStructuredType().getObjectID()).append(",");
                    sb.append(entityView.getBasedOnStructuredType().getNumID()).append(",");
                    sb.append(this.replaceAndQuoteString(entityView.getBasedOnStructuredType().getName())).append(",");
                } else {
                    sb.append("").append(",");
                    sb.append("").append(",");
                    sb.append("").append(",");
                }
                sb.append(entityView.getUserDefined() ? "Y" : "N").append(",");
                sb.append(entityView.getViewType()).append(",");
                lines.add(sb.toString());
                this.getCsvExporter().addNote(entityView.getObjectID(), entityView.getNumID(), "EntityView", entityView.getNotes());
                this.getCsvExporter().addComment(entityView.getObjectID(), entityView.getNumID(), "EntityView", entityView.getComment());
                this.getCsvExporter().addCommentRDBMS(entityView.getObjectID(), entityView.getNumID(), "EntityView", entityView.getCommentInRDBMS());
            }
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_EntityViews.csv";
    }
}

