/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.storage.RDBMSType;

public class EHDomainCheckConstraint
extends ExportHandler {
    public EHDomainCheckConstraint(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("Domain_ID").append(",");
        sb.append("Num_Domain_ID").append(",");
        sb.append("Sequence").append(",");
        sb.append("Constraint_Name").append(",");
        sb.append("Text").append(",");
        sb.append("Database_Type").append(",");
        sb.append("Domain_Name");
        lines.add(sb.toString());
        Iterator it = this.getDesign().getDomainSet().iterator();
        while (it.hasNext()) {
            Domain domain = (Domain)it.next();
            CheckConstraint check = domain.getCheck();
            int seq = 0;
            if (check == null) continue;
            String generic = check.getGenericConstraint();
            if (generic != null && !"".equalsIgnoreCase(generic)) {
                ++seq;
                sb = new StringBuffer();
                sb.append(domain.getObjectID()).append(",");
                sb.append(domain.getNumID()).append(",");
                sb.append(seq).append(",");
                sb.append(this.replaceAndQuoteString(check.getName())).append(",");
                sb.append(this.replaceAndQuoteString(generic)).append(",");
                sb.append("GENERIC").append(",");
                sb.append(this.replaceAndQuoteString(domain.getName())).append(",");
                lines.add(sb.toString());
            }
            Object[] types = check.getTypes();
            for (int i = 0; i < types.length; ++i) {
                RDBMSType type = (RDBMSType)types[i];
                String text = check.getImplementationFor(type);
                if (text == null || "".equalsIgnoreCase(text)) continue;
                ++seq;
                sb = new StringBuffer();
                sb.append(domain.getObjectID()).append(",");
                sb.append(domain.getNumID()).append(",");
                sb.append(seq).append(",");
                sb.append(check.getName()).append(",");
                sb.append(this.replaceAndQuoteString(text)).append(",");
                sb.append(type.getName()).append(",");
                sb.append(this.replaceAndQuoteString(domain.getName())).append(",");
                lines.add(sb.toString());
            }
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_Domain_Check_Constraints.csv";
    }
}

