/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;

public class EHColumn
extends ExportHandler {
    public EHColumn(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("Column_Name").append(",");
        sb.append("ObjectID").append(",");
        sb.append("NumOID").append(",");
        sb.append("ImportID").append(",");
        sb.append("ContainerID").append(",");
        sb.append("Num_ContainerID").append(",");
        sb.append("Mandatory").append(",");
        sb.append("DataType_Kind").append(",");
        sb.append("Value_Type").append(",");
        sb.append("Computed").append(",");
        sb.append("Formula").append(",");
        sb.append("ScopeEntityID").append(",");
        sb.append("Num_ScopeEntityID").append(",");
        sb.append("Domain_ID").append(",");
        sb.append("Num_Domain_ID").append(",");
        sb.append("Logical_Type_ID").append(",");
        sb.append("Num_Logical_Type_ID").append(",");
        sb.append("Distinct_Type_ID").append(",");
        sb.append("Num_Distinct_Type_ID").append(",");
        sb.append("Structured_Type_ID").append(",");
        sb.append("Num_Structured_Type_ID").append(",");
        sb.append("Collection_Type_ID").append(",");
        sb.append("Num_Collection_Type_ID").append(",");
        sb.append("Check_Constraint_Name").append(",");
        sb.append("Default_Value").append(",");
        sb.append("Use_Domain_Constraint").append(",");
        sb.append("Domain_Name").append(",");
        sb.append("Logical_Type_Name").append(",");
        sb.append("Structured_Type_Name").append(",");
        sb.append("Distinct_Type_Name").append(",");
        sb.append("Collection_Type_Name").append(",");
        sb.append("Uses_Default").append(",");
        sb.append("Engineer").append(",");
        sb.append("Table_Name").append(",");
        sb.append("PK_Flag").append(",");
        sb.append("FK_Flag").append(",");
        sb.append("Native_Type").append(",");
        sb.append("Sequence").append(",");
        sb.append("ModelID").append(",");
        sb.append("Num_ModelID").append(",");
        sb.append("Model_Name").append(",");
        sb.append("T_Size").append(",");
        sb.append("T_Precision").append(",");
        sb.append("T_Scale");
        lines.add(sb.toString());
        for (RelationalDesign phDesign : this.getDesign().getRelationalDesigns()) {
            if (!this.getCsvExporter().isModelSelected(phDesign)) continue;
            Iterator cit = phDesign.getColumnSet().iterator();
            while (cit.hasNext()) {
                Column column = (Column)cit.next();
                sb = new StringBuffer();
                sb.append(this.replaceAndQuoteString(column.getName())).append(",");
                sb.append(column.getObjectID()).append(",");
                sb.append(column.getNumID()).append(",");
                sb.append(column.getImportedId() != null ? column.getImportedId() : "").append(",");
                sb.append(column.getContainer().getObjectID()).append(",");
                sb.append(column.getContainer().getNumID()).append(",");
                sb.append(column.getNullsAllowed() ? "N" : "Y").append(",");
                switch (column.getUse()) {
                    case 0: {
                        sb.append("Domain").append(",");
                        break;
                    }
                    case 1: {
                        sb.append("Logical Type").append(",");
                        break;
                    }
                    case 2: {
                        sb.append("Distinct Type").append(",");
                        break;
                    }
                    case 3: {
                        if (column.isReference()) {
                            sb.append("Ref Struct Type").append(",");
                            break;
                        }
                        sb.append("Structured Type").append(",");
                        break;
                    }
                    case 4: {
                        sb.append("Collection Type").append(",");
                    }
                }
                sb.append(column.getSourceType()).append(",");
                sb.append(column.isComputed() != false ? "Y" : "N").append(",");
                sb.append(this.replaceAndQuoteString(column.getFormulaDesc())).append(",");
                if (column.getScope() != null) {
                    sb.append(column.getScope().getObjectID()).append(",");
                    sb.append(column.getScope().getNumID()).append(",");
                } else {
                    sb.append("").append(",");
                    sb.append("").append(",");
                }
                sb.append(column.getDomain().getObjectID()).append(",");
                sb.append(column.getDomain().getNumID()).append(",");
                sb.append(column.getLogicalDatatype().getObjectID()).append(",");
                sb.append(column.getLogicalDatatype().getNumID()).append(",");
                if (column.getDistinctType() != null) {
                    sb.append(column.getDistinctType().getObjectID()).append(",");
                    sb.append(column.getDistinctType().getNumID()).append(",");
                } else {
                    sb.append("").append(",");
                    sb.append("").append(",");
                }
                if (column.getStructuredType() != null) {
                    sb.append(column.getStructuredType().getObjectID()).append(",");
                    sb.append(column.getStructuredType().getNumID()).append(",");
                } else {
                    sb.append("").append(",");
                    sb.append("").append(",");
                }
                if (column.getCollectionType() != null) {
                    sb.append(column.getCollectionType().getObjectID()).append(",");
                    sb.append(column.getCollectionType().getNumID()).append(",");
                } else {
                    sb.append("").append(",");
                    sb.append("").append(",");
                }
                sb.append(column.getConstraintName()).append(",");
                sb.append(this.replaceAndQuoteString(column.getDefaultValue())).append(",");
                sb.append(column.getUseDomainConstraints() ? "Y" : "N").append(",");
                if (column.getUse() == 0) {
                    sb.append(this.replaceAndQuoteString(column.getDomain().getName())).append(",");
                    sb.append(column.getDomain().getLogicalDatatype().getName()).append(",");
                } else if (column.getUse() == 1) {
                    sb.append("").append(",");
                    sb.append(column.getLogicalDatatype().getName()).append(",");
                } else if (column.getUse() == 2) {
                    sb.append("").append(",");
                    sb.append(column.getDistinctType().getLogicalDataType().getName()).append(",");
                } else {
                    sb.append("").append(",");
                    sb.append("").append(",");
                }
                if (column.getStructuredType() != null) {
                    sb.append(this.replaceAndQuoteString(column.getStructuredType().getName())).append(",");
                } else {
                    sb.append("").append(",");
                }
                if (column.getDistinctType() != null) {
                    sb.append(this.replaceAndQuoteString(column.getDistinctType().getName())).append(",");
                } else {
                    sb.append("").append(",");
                }
                if (column.getCollectionType() != null) {
                    sb.append(this.replaceAndQuoteString(column.getCollectionType().getName())).append(",");
                } else {
                    sb.append("").append(",");
                }
                sb.append(column.getUsesDefaultValue() ? "Y" : "N").append(",");
                sb.append(column.getShouldEngineer() ? "Y" : "N").append(",");
                sb.append(this.replaceAndQuoteString(column.getContainer().getName())).append(",");
                if (column.isPKElement()) {
                    sb.append("P").append(",");
                } else {
                    sb.append("").append(",");
                }
                if (column.isFKColumn()) {
                    sb.append("F").append(",");
                } else {
                    sb.append("").append(",");
                }
                sb.append(column.getDataType().getName()).append(",");
                sb.append(column.getContainer().getIndexOf(column) + 1).append(",");
                sb.append(phDesign.getObjectID()).append(",");
                sb.append(phDesign.getNumID()).append(",");
                sb.append(this.replaceAndQuoteString(phDesign.getName())).append(",");
                if (column.getUse() == 0) {
                    sb.append(column.getDomain().getSize()).append(",");
                    sb.append(column.getDomain().getPrecision()).append(",");
                    sb.append(column.getDomain().getScale()).append(",");
                } else if (column.getUse() == 1) {
                    sb.append(column.getSize()).append(",");
                    sb.append(column.getPrecision()).append(",");
                    sb.append(column.getScale()).append(",");
                } else {
                    sb.append("").append(",");
                    sb.append("").append(",");
                    sb.append("").append(",");
                }
                lines.add(sb.toString());
                this.getCsvExporter().addNote(column.getObjectID(), column.getNumID(), "Column", column.getNotes());
                this.getCsvExporter().addComment(column.getObjectID(), column.getNumID(), "Column", column.getComment());
                this.getCsvExporter().addCommentRDBMS(column.getObjectID(), column.getNumID(), "Column", column.getCommentInRDBMS());
            }
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_Columns.csv";
    }
}

