/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayModelCache;
import oracle.dbtools.raptor.controls.display.DisplayRegistry;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.report.addin.ReportEditor;
import oracle.dbtools.raptor.report.navigatorV2.ReportEditorNode;
import oracle.dbtools.raptor.report.navigatorV2.ReportNode;
import oracle.dbtools.raptor.report.ui.AdvancedPanel;
import oracle.dbtools.raptor.report.ui.ReportArb;
import oracle.dbtools.raptor.report.ui.ReportTreePanel;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.GuidGen;
import oracle.javatools.dialogs.MessageDialog;

public class ReportDialog
implements ActionListener {
    private DefaultContainer _parentNode;
    private DefaultContainer _childNode;
    private String _existRptName;
    private JEWTDialog _rptDialog;
    private ReportTreePanel _panel = null;
    private StringBuffer _errMsg = new StringBuffer();

    public ReportDialog(DefaultContainer defaultContainer, DefaultContainer defaultContainer2, String string, String string2) {
        this._parentNode = defaultContainer;
        this._childNode = defaultContainer2;
        this._existRptName = string2;
        this.init(string, null);
    }

    public ReportDialog(DefaultContainer defaultContainer, DefaultContainer defaultContainer2, String string, String string2, String string3) {
        this._parentNode = defaultContainer;
        this._childNode = defaultContainer2;
        this._existRptName = string3;
        this.init(string2, string);
    }

    private void init(String string, String string2) {
        String string3 = null;
        if (this._childNode == null) {
            string3 = ReportArb.getString("CREATE_REPORT_TITLE");
            this._panel = this.getNewReportPanel(string);
        } else {
            string3 = ReportArb.getString("EDIT_REPORT_TITLE");
            this._panel = this.getEditReportPanel();
        }
        if (string2 != null) {
            this._panel.setConnectionName(string2);
        }
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._panel, "f1_userdefinedreport_html");
        this._rptDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)this._panel, null, (String)string3, (int)14);
        this._rptDialog.addActionListener((ActionListener)this);
        this._rptDialog.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                Component component;
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && (component = hierarchyEvent.getComponent()).isShowing()) {
                    ReportDialog.this.resizeDialog();
                    component.removeHierarchyListener(this);
                }
            }
        });
    }

    private void resizeDialog() {
        double d;
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        Dimension dimension = ideMainWindow.getSize();
        double d2 = 0.8 * dimension.getHeight();
        if (d2 > 0.625 * (d = 0.8 * dimension.getWidth())) {
            d2 = 0.625 * d;
        } else if (d > 1.6 * d2) {
            d = 1.6 * d2;
        }
        Dimension dimension2 = this._panel.getPreferredSize();
        if (d2 < dimension2.getHeight() || d < dimension2.getWidth()) {
            d2 = dimension2.getHeight();
            d = dimension2.getWidth();
        }
        this._rptDialog.setSize(new Dimension((int)d, (int)d2));
        Point point = ideMainWindow.getLocationOnScreen();
        int n = point.x + (dimension.width - (int)d) / 2;
        int n2 = point.y + (dimension.height - (int)d2) / 2;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        this._rptDialog.setLocation(n, n2);
    }

    private ReportTreePanel getNewReportPanel(String string) {
        ReportTreePanel reportTreePanel = new ReportTreePanel(string);
        if (this._parentNode != null) {
            reportTreePanel.setPath(this._parentNode.getURL().getPath());
        }
        return reportTreePanel;
    }

    private ReportTreePanel getEditReportPanel() {
        ReportTreePanel reportTreePanel = new ReportTreePanel(((ReportNode)this._childNode).getReport());
        reportTreePanel.setPath(this._childNode.getURL().getPath());
        return reportTreePanel;
    }

    private boolean validateReportInfo(String string, AdvancedPanel advancedPanel) {
        this._errMsg = new StringBuffer();
        if (this._parentNode == null) {
            this._errMsg.append(ReportArb.getString("MASTER_RPT_NAME_MISSING")).append("\n\n");
        } else {
            Object object;
            if (string == null || string.isEmpty()) {
                this._errMsg.append(ReportArb.getString("MASTER_RPT_NAME_MISSING")).append("\n\n");
            } else {
                object = this._parentNode.getChildren();
                while (object.hasNext()) {
                    DefaultContainer defaultContainer = (DefaultContainer)object.next();
                    if (this._existRptName.equals(defaultContainer.getShortLabel()) || !defaultContainer.getShortLabel().equals(string)) continue;
                    this._errMsg.append(ReportArb.getString("MASTER_RPT_NAME_EXISTS")).append("\n\n");
                    break;
                }
            }
            if (advancedPanel != null && advancedPanel.getActions() != null) {
                object = advancedPanel.getActions();
                boolean bl = false;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    ObjectAction objectAction = (ObjectAction)iterator.next();
                    if (objectAction.getTitle() == null || objectAction.getTitle().isEmpty()) {
                        this._errMsg.append(ReportArb.getString("DRILL_DOWN_NAME_MISSING")).append("\n\n");
                        bl = true;
                    }
                    if (objectAction.getClassArgs() == null || objectAction.getClassArgs().isEmpty()) {
                        this._errMsg.append(ReportArb.getString("DRILL_DOWN_REPORT_MISSING")).append("\n\n");
                        bl = true;
                    }
                    if (!bl) continue;
                    break;
                }
            }
        }
        return this._errMsg.length() <= 0;
    }

    private void saveReportInformation(DisplayModel displayModel) {
        Object object;
        if (displayModel.getID() == null) {
            displayModel.setID(GuidGen.toString((byte[])GuidGen.uuidCreate()));
        }
        if (displayModel.getExtValues() == null) {
            object = null;
            try {
                object = DisplayRegistry.getDetailPanel((String)displayModel.getStyle());
            }
            catch (Exception exception) {
                // empty catch block
            }
            displayModel.setExtValues(object.getValues());
        }
        DisplayModelCache.putDisplayModel((DisplayModel)displayModel);
        try {
            if (this._childNode == null) {
                object = new ReportNode(new URL(this._parentNode.getURL() + "/" + displayModel.getName()), displayModel);
                ((ReportNode)object).setEditable(true);
                this._parentNode.add((Element)object);
                UpdateMessage.fireChildAdded((Subject)this._parentNode, (Element)object);
            } else {
                this._childNode.setURL(new URL(this._parentNode.getURL() + "/" + displayModel.getName()));
                ((ReportNode)this._childNode).setReport(displayModel);
                UpdateMessage.fireStructureChanged((Subject)this._childNode);
                UpdateMessage.fireObjectRenamed((Subject)this._childNode);
                this.refreshOpenReport(this._childNode.getURL());
            }
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, malformedURLException.getStackTrace()[0].toString(), malformedURLException);
        }
        this._rptDialog.dispose();
        this.cleanUp();
    }

    private void refreshOpenReport(URL uRL) {
        List list = EditorManager.getEditorManager().getAllEditors();
        for (Editor editor : list) {
            ReportNode reportNode;
            ReportEditor reportEditor;
            ReportEditorNode reportEditorNode;
            if (!(editor instanceof ReportEditor) || (reportEditorNode = (ReportEditorNode)(reportEditor = (ReportEditor)editor).getContext().getNode()) == null || (reportNode = reportEditorNode.getReportNode()) == null || !uRL.equals(reportNode.getURL())) continue;
            reportEditor.updateContent();
            reportEditorNode.notifyObservers(this, new UpdateMessage(UpdateMessage.OBJECT_RENAMED, (Object)this));
        }
    }

    private void showError() {
        MessageDialog.error((Component)this._rptDialog, (Object)this._errMsg.toString(), (String)ReportArb.getString("REPORT_ERROR_TITLE"), null);
    }

    private void cleanUp() {
        if (this._panel != null) {
            this._panel.cleanUp();
        }
        this._panel = null;
        this._parentNode = null;
        this._childNode = null;
        this._existRptName = null;
        this._rptDialog = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ReportDialog.this._panel.getAdvPanel() != null && ReportDialog.this._panel.getAdvPanel().getTable().getCellEditor() != null) {
                    ReportDialog.this._panel.getAdvPanel().getTable().getCellEditor().stopCellEditing();
                }
                ReportDialog.this._panel.prepareForSave();
                boolean bl = ReportDialog.this.validateReportInfo(ReportDialog.this._panel.getMasterReportName(), ReportDialog.this._panel.getAdvPanel());
                if (bl) {
                    ReportDialog.this.saveReportInformation(ReportDialog.this._panel.getModel());
                    if (ReportDialog.this._rptDialog != null) {
                        ReportDialog.this._rptDialog.dispose();
                        ReportDialog.this._rptDialog.removeActionListener((ActionListener)ReportDialog.this);
                    }
                } else {
                    ReportDialog.this.showError();
                }
            }
        });
    }

    public boolean runDialog() {
        boolean bl = WizardLauncher.runDialog((JDialog)this._rptDialog);
        this.cleanUp();
        return bl;
    }

    public DisplayModel getModel() {
        return this._panel.getModel();
    }
}

