/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayRegistry;
import oracle.dbtools.raptor.report.ui.BindNode;
import oracle.dbtools.raptor.report.ui.ChildReportsNode;
import oracle.dbtools.raptor.report.ui.DisplayModelContext;
import oracle.dbtools.raptor.report.ui.DrillDownNode;
import oracle.dbtools.raptor.report.ui.EditMode;
import oracle.dbtools.raptor.report.ui.PropertyNode;
import oracle.dbtools.raptor.report.ui.ReportArb;
import oracle.dbtools.raptor.report.ui.ReportNamePanel;
import oracle.dbtools.raptor.report.ui.ReportTreeContext;
import oracle.dbtools.raptor.report.ui.ReportTreeNode;
import oracle.dbtools.raptor.report.ui.ReportTreePanel;
import oracle.dbtools.raptor.report.ui.SQLNode;

public class MasterNode
extends ReportTreeNode
implements DisplayModelContext {
    public static final String LABEL = ReportArb.getString("REPORT_NODE");
    public static final String ICON = ReportArb.getString("REPORT_ICON");
    private ReportNamePanel panel;
    private SQLNode sqlNode;
    private ChildReportsNode childReportsNode;
    private BindNode bindNode;
    private DrillDownNode drillDownNode;
    private PropertyNode propertyNode;

    public MasterNode(ReportTreePanel reportTreePanel, EditMode editMode, DisplayModel displayModel) {
        super(new ReportTreeContext(reportTreePanel, displayModel != null ? displayModel.getName() : "", editMode, displayModel));
    }

    public JTree createJTree() {
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.jNode());
        return new JTree(defaultTreeModel);
    }

    public void populateTree() {
        ReportTreeContext reportTreeContext = this.context();
        this.sqlNode = new SQLNode(reportTreeContext, null);
        this.childReportsNode = new ChildReportsNode(reportTreeContext);
        this.bindNode = new BindNode(reportTreeContext);
        this.drillDownNode = new DrillDownNode(reportTreeContext);
        this.propertyNode = new PropertyNode(reportTreeContext);
        this.sqlNode.insertAtTail(this);
        this.childReportsNode.insertAtTail(this);
        this.bindNode.insertAtTail(this);
        this.drillDownNode.insertAtTail(this);
        this.propertyNode.insertAtTail(this);
        reportTreeContext.setSQLNode(this.sqlNode);
        this.updatePageVisibility();
        reportTreeContext.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("MODE") || string.equals("STYLE")) {
                    MasterNode.this.updatePageVisibility();
                }
                if (string.equals("MODE")) {
                    MasterNode.this.switchMode();
                }
            }
        });
        TreePath treePath = new TreePath(this.jNode().getPath());
        reportTreeContext.treePanel().getReportTree().expandPath(treePath);
    }

    @Override
    public String typeLabel() {
        return LABEL;
    }

    @Override
    public String iconName() {
        return ICON;
    }

    @Override
    public ReportNamePanel panel() {
        if (this.panel == null) {
            this.panel = new ReportNamePanel(this.context(), new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("NAME")) {
                        MasterNode.this.context().setName((String)propertyChangeEvent.getNewValue());
                    } else if (propertyChangeEvent.getPropertyName().equals("STYLE")) {
                        MasterNode.this.context().setStyle(MasterNode.this.panel.getStyle());
                    }
                }
            });
            DisplayModel displayModel = this.context().model();
            if (displayModel != null) {
                this.panel.setInfo(displayModel.getName(), displayModel.getDescription(), displayModel.getToolTip(), displayModel.getStyle());
            } else {
                this.panel.setInfo(this.name(), "", "", "");
            }
        }
        return this.panel;
    }

    @Override
    public SQLNode sqlNode() {
        return this.sqlNode;
    }

    @Override
    public ChildReportsNode childReportsNode() {
        return this.childReportsNode;
    }

    @Override
    public BindNode bindNode() {
        return this.bindNode;
    }

    @Override
    public DrillDownNode drillDownNode() {
        return this.drillDownNode;
    }

    @Override
    public PropertyNode propertyNode() {
        return this.propertyNode;
    }

    public void prepareForSave() {
        EditMode editMode = this.context().mode();
        if (editMode == EditMode.NEW) {
            this.sqlNode.panel().setSQL(this.panel.getSQL());
        }
    }

    private void switchMode() {
        EditMode editMode = this.context().mode();
        this.context().treePanel().getReportTree().setSelectionRow(0);
        if (editMode == EditMode.NEW) {
            this.panel.setSQL(this.sqlNode.panel().getSQL());
        } else {
            this.sqlNode.panel().setSQL(this.panel.getSQL());
        }
    }

    private void updatePageVisibility() {
        boolean bl = this.context().mode() != EditMode.NEW;
        this.sqlNode.setVisible(bl);
        this.childReportsNode.setVisible(bl && this.childReportsAllowed());
        this.bindNode.setVisible(bl);
        this.drillDownNode.setVisible(bl);
        this.propertyNode.setVisible(true);
    }

    private boolean childReportsAllowed() {
        ArrayList arrayList = DisplayRegistry.getStylesAllowChildren();
        return arrayList.contains(this.context().style());
    }
}

