/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.report.Messages;
import oracle.dbtools.raptor.report.ui.CustomCellRenderer;

public class BindPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTable _table;
    private DefaultTableModel _model;

    public BindPanel() {
        this.init();
    }

    public BindPanel(List<Bind> list) {
        this.init();
        for (Bind bind : list) {
            String string = bind.getName();
            this.addRow(string, bind.getPrompt(), bind.getValue(), bind.getTooltip());
        }
    }

    public void setBinds(List<Bind> list) {
        int n = this._model.getRowCount();
        for (int i = n - 1; i >= 0; --i) {
            this._model.removeRow(i);
        }
        for (Bind bind : list) {
            String string = bind.getName();
            this.addRow(string, bind.getPrompt(), bind.getValue(), bind.getTooltip());
        }
    }

    public void init() {
        this.setLayout(new GridBagLayout());
        this._model = new DefaultTableModel();
        this._table = new JTable(this._model){
            private static final long serialVersionUID = 1L;

            @Override
            public TableCellEditor getCellEditor(int n, int n2) {
                JTextField jTextField = new JTextField();
                final DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jTextField);
                jTextField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        defaultCellEditor.stopCellEditing();
                    }
                });
                return defaultCellEditor;
            }

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                return new CustomCellRenderer();
            }
        };
        this._table.setBorder(new LineBorder(Color.LIGHT_GRAY));
        this._table.setPreferredScrollableViewportSize(new Dimension(400, 300));
        this._model.addColumn(Messages.getString("BindPanel.0"));
        this._model.addColumn(Messages.getString("BindPanel.1"));
        this._model.addColumn(Messages.getString("BindPanel.2"));
        this._model.addColumn(Messages.getString("BindPanel.3"));
        JScrollPane jScrollPane = new JScrollPane(this._table);
        this.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 8), 0, 0));
        this._table.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (BindPanel.this._table.getEditingColumn() > -1 && BindPanel.this._table.getEditingRow() > -1) {
                    BindPanel.this._table.getCellEditor(BindPanel.this._table.getEditingRow(), BindPanel.this._table.getEditingColumn()).stopCellEditing();
                }
            }
        });
    }

    public void addRow(String string, String string2, String string3, String string4) {
        this._model.addRow(new Object[]{string, string2, string3, string4});
    }

    public List<Bind> getBinds() {
        Bind bind = null;
        ArrayList<Bind> arrayList = new ArrayList<Bind>();
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            String string = (String)this._table.getModel().getValueAt(i, 2);
            if (string == null || string.equals("null") || string.equals("")) {
                string = "NULL_VALUE";
            }
            bind = new Bind((String)this._table.getModel().getValueAt(i, 0), null, (String)this._table.getModel().getValueAt(i, 1), string, (String)this._table.getModel().getValueAt(i, 3));
            arrayList.add(bind);
        }
        return arrayList;
    }
}

