/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayModelCache;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.report.Messages;
import oracle.dbtools.raptor.report.navigatorV2.FolderNode;
import oracle.dbtools.raptor.report.navigatorV2.ReportNode;
import oracle.dbtools.raptor.report.navigatorV2.RootNode;
import oracle.dbtools.raptor.report.ui.CustomCellRenderer;
import oracle.ide.model.DefaultContainer;
import oracle.ide.util.GuidGen;

public class AdvancedPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTable _table;
    private DefaultTableModel _model;
    private JTextField _id;
    TableColumn col;

    public AdvancedPanel() {
        this.init();
    }

    public void init() {
        this.setLayout(new GridBagLayout());
        this._id = new JTextField();
        this._id.setText(GuidGen.toString((byte[])GuidGen.uuidCreate()));
        this._model = new DefaultTableModel();
        this._table = new JTable(this._model){
            private static final long serialVersionUID = 1L;

            @Override
            public TableCellEditor getCellEditor(int n, int n2) {
                TreeModel treeModel = AdvancedPanel.this.getTree().getModel();
                JComboBox jComboBox = new JComboBox(new TreeListModel(treeModel));
                jComboBox.setRenderer(new TreeListCellRenderer(treeModel, new DefaultTreeCellRenderer()));
                DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jComboBox);
                defaultCellEditor.setClickCountToStart(2);
                if (n2 == 0) {
                    return new DefaultCellEditor(new JTextField());
                }
                return defaultCellEditor;
            }

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                return new CustomCellRenderer();
            }
        };
        this._table.setBorder(new LineBorder(Color.LIGHT_GRAY));
        this._table.setPreferredScrollableViewportSize(new Dimension(400, 300));
        this._model.addColumn(Messages.getString("AdvancedPanel.0"));
        this._model.addColumn(Messages.getString("AdvancedPanel.1"));
        JScrollPane jScrollPane = new JScrollPane(this._table);
        this.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 8), 0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        JButton jButton = new JButton();
        jButton.setText(Messages.getString("AdvancedPanel.2"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedPanel.this.addRow(null, null);
            }
        });
        jPanel.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        JButton jButton2 = new JButton();
        jButton2.setText(Messages.getString("AdvancedPanel.3"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                while (AdvancedPanel.this._table.getSelectedRowCount() > 0) {
                    AdvancedPanel.this._model.removeRow(AdvancedPanel.this._table.getSelectedRow());
                }
            }
        });
        jPanel.add((Component)jButton2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 10, 0, 0), 0, 0));
        jPanel.add(Box.createGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 0, 10, 0), 0, 0));
    }

    public void addRow(String string, Object object) {
        this._model.addRow(new Object[]{string, object});
    }

    public void addChildren(DefaultContainer defaultContainer, myDefaultMutableTreeNode myDefaultMutableTreeNode2) {
        Iterator iterator = defaultContainer.getChildren();
        while (iterator.hasNext()) {
            DefaultContainer defaultContainer2 = (DefaultContainer)iterator.next();
            myDefaultMutableTreeNode myDefaultMutableTreeNode3 = new myDefaultMutableTreeNode(defaultContainer2.getShortLabel());
            if (defaultContainer2 instanceof ReportNode) {
                myDefaultMutableTreeNode3.setNode(((ReportNode)defaultContainer2).getReport());
                myDefaultMutableTreeNode2.add(myDefaultMutableTreeNode3);
                continue;
            }
            if (!(defaultContainer2 instanceof FolderNode)) continue;
            myDefaultMutableTreeNode2.add(myDefaultMutableTreeNode3);
            if (defaultContainer2.size() <= 0) continue;
            this.addChildren(defaultContainer2, myDefaultMutableTreeNode3);
        }
    }

    private JTree getTree() {
        myDefaultMutableTreeNode myDefaultMutableTreeNode2 = new myDefaultMutableTreeNode(Messages.getString("AdvancedPanel.4"));
        RootNode rootNode = RootNode.getInstance();
        this.addChildren(rootNode, myDefaultMutableTreeNode2);
        JTree jTree = new JTree(myDefaultMutableTreeNode2);
        return jTree;
    }

    public List<ObjectAction> getActions() {
        if (this._table.getRowCount() > 0) {
            ArrayList<ObjectAction> arrayList = new ArrayList<ObjectAction>();
            ObjectAction objectAction = null;
            for (int i = 0; i < this._table.getRowCount(); ++i) {
                objectAction = new ObjectAction();
                objectAction.setTitle((String)this._table.getValueAt(i, 0));
                if (this._table.getValueAt(i, 1) == null || this._table.getValueAt(i, 1).equals("")) {
                    objectAction.setClassArgs(null);
                } else {
                    objectAction.setClassArgs(((myDefaultMutableTreeNode)this._table.getValueAt(i, 1)).getReport().getID());
                }
                objectAction.setClassName("oracle.dbtools.raptor.report.addin.DrillReportAction", this.getClass().getClassLoader());
                arrayList.add(objectAction);
            }
            return arrayList;
        }
        return null;
    }

    public String getId() {
        return this._id.getText();
    }

    public JTable getTable() {
        return this._table;
    }

    public void setModel(DisplayModel displayModel) {
        if (displayModel.getID() != null && !displayModel.getID().equals("")) {
            this._id.setText(displayModel.getID());
        } else {
            this._id.setText(GuidGen.toString((byte[])GuidGen.uuidCreate()));
        }
        if (displayModel.getActions() != null && displayModel.getActions().size() > 0) {
            this._model.setRowCount(0);
            for (ObjectAction objectAction : displayModel.getActions()) {
                DisplayModel displayModel2 = DisplayModelCache.getDisplayModel((String)objectAction.getClassArgs());
                if (displayModel2 == null) continue;
                myDefaultMutableTreeNode myDefaultMutableTreeNode2 = new myDefaultMutableTreeNode(displayModel2.getName());
                myDefaultMutableTreeNode2.setNode(displayModel2);
                this.addRow(objectAction.getTitle(), myDefaultMutableTreeNode2);
            }
        }
    }

    public class myDefaultMutableTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        private boolean report;
        private DisplayModel _model;

        public myDefaultMutableTreeNode() {
            this.report = false;
        }

        public myDefaultMutableTreeNode(Object object, boolean bl) {
            super(object, bl);
            this.report = false;
        }

        public myDefaultMutableTreeNode(Object object) {
            super(object);
            this.report = false;
        }

        public void setNode(DisplayModel displayModel) {
            this._model = displayModel;
            this.report = true;
        }

        public boolean isReport() {
            return this.report;
        }

        public DisplayModel getReport() {
            return this._model;
        }
    }

    class TreeListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final long serialVersionUID = -6887751118080286372L;
        private JTree tree = new JTree();
        TreeModel treeModel;
        TreeCellRenderer treeRenderer;
        IndentBorder indentBorder = new IndentBorder();

        public TreeListCellRenderer(TreeModel treeModel, TreeCellRenderer treeCellRenderer) {
            this.treeModel = treeModel;
            this.treeRenderer = treeCellRenderer;
            this.setLayout(new FlowLayout(0, 0, 0));
            this.setBorder(this.indentBorder);
            this.setOpaque(false);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object == null) {
                this.removeAll();
                return this;
            }
            boolean bl3 = this.treeModel.isLeaf(object);
            Component component = this.treeRenderer.getTreeCellRendererComponent(this.tree, object, bl, true, bl3, n, bl2);
            this.removeAll();
            this.add(component);
            PreorderEnumeration preorderEnumeration = new PreorderEnumeration(this.treeModel);
            for (int i = 0; i <= n; ++i) {
                preorderEnumeration.nextElement();
            }
            this.indentBorder.setDepth(preorderEnumeration.getDepth());
            return this;
        }
    }

    class IndentBorder
    extends EmptyBorder {
        private static final long serialVersionUID = 1L;
        int indent;

        public IndentBorder() {
            super(0, 0, 0, 0);
            this.indent = UIManager.getInt("Tree.leftChildIndent");
        }

        public void setDepth(int n) {
            this.left = this.indent * n;
        }
    }

    class TreeListModel
    extends AbstractListModel
    implements ComboBoxModel {
        private static final long serialVersionUID = 1252605542549440356L;
        private TreeModel treeModel;
        private Object selectedObject;

        public TreeListModel(TreeModel treeModel) {
            this.treeModel = treeModel;
        }

        @Override
        public int getSize() {
            int n = 0;
            PreorderEnumeration preorderEnumeration = new PreorderEnumeration(this.treeModel);
            while (preorderEnumeration.hasMoreElements()) {
                preorderEnumeration.nextElement();
                ++n;
            }
            return n;
        }

        @Override
        public Object getElementAt(int n) {
            PreorderEnumeration preorderEnumeration = new PreorderEnumeration(this.treeModel);
            for (int i = 0; i < n; ++i) {
                preorderEnumeration.nextElement();
            }
            return preorderEnumeration.nextElement();
        }

        @Override
        public void setSelectedItem(Object object) {
            if ((this.selectedObject != null && !this.selectedObject.equals(object) || this.selectedObject == null && object != null) && object instanceof myDefaultMutableTreeNode && ((myDefaultMutableTreeNode)object).isReport()) {
                this.selectedObject = object;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedObject;
        }
    }

    class PreorderEnumeration
    implements Enumeration<Object> {
        private TreeModel treeModel;
        protected Stack<Enumeration<?>> stack;
        private int depth = 0;

        public PreorderEnumeration(TreeModel treeModel) {
            this.treeModel = treeModel;
            Vector<Object> vector = new Vector<Object>(1);
            vector.addElement(treeModel.getRoot());
            this.stack = new Stack();
            this.stack.push(vector.elements());
        }

        @Override
        public boolean hasMoreElements() {
            return !this.stack.empty() && this.stack.peek().hasMoreElements();
        }

        @Override
        public Object nextElement() {
            Enumeration<?> enumeration = this.stack.peek();
            Object obj = enumeration.nextElement();
            int n = this.depth = enumeration instanceof ChildrenEnumeration ? ((ChildrenEnumeration)enumeration).depth : 0;
            if (!enumeration.hasMoreElements()) {
                this.stack.pop();
            }
            ChildrenEnumeration childrenEnumeration = new ChildrenEnumeration(this.treeModel, obj);
            childrenEnumeration.depth = this.depth + 1;
            if (childrenEnumeration.hasMoreElements()) {
                this.stack.push(childrenEnumeration);
            }
            return obj;
        }

        public int getDepth() {
            return this.depth;
        }
    }

    class ChildrenEnumeration
    implements Enumeration<Object> {
        TreeModel treeModel;
        Object node;
        int depth;
        int index = -1;

        public ChildrenEnumeration(TreeModel treeModel, Object object) {
            this.treeModel = treeModel;
            this.node = object;
        }

        @Override
        public boolean hasMoreElements() {
            return this.index < this.treeModel.getChildCount(this.node) - 1;
        }

        @Override
        public Object nextElement() {
            return this.treeModel.getChild(this.node, ++this.index);
        }
    }
}

