/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.options;

import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.insight.options.InsightOptions;
import oracle.ide.insight.options.InsightOptionsBundle;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;

public final class InsightOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener,
ChangeListener {
    private JCheckBox checkbox_completionEnablePopup;
    private JSlider slider_completionPopupDelay;
    private JLabel label_completionSliderMax;
    private JLabel label_completionSliderMin;
    private JLabel label_completionPopupDelayText;
    private JCheckBox checkbox_parameterEnablePopup;
    private JSlider slider_parameterPopupDelay;
    private JLabel label_parameterPopupDelayText;
    private JLabel label_parameterSliderMin;
    private JLabel label_parameterSliderMax;
    private NumberFormat numberFormatter;

    public InsightOptionsPanel() {
        this.setHelpID("f1_idedidesetcodeinsight_html");
        this.initializeComponent();
    }

    public void onEntry(TraversableContext tc) {
        InsightOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
    }

    public void onExit(TraversableContext tc) {
        InsightOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private InsightOptions findOptions(TraversableContext tc) {
        InsightOptions options = InsightOptions.getInstance(tc.getPropertyStorage());
        return options;
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        InsightOptions options = this.findOptions(tc);
        InsightOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(InsightOptions options) {
        EditorProperties properties = EditorProperties.getProperties();
        boolean completionEnablePopup = options.isCompletePopupEnabled();
        properties.putBooleanProperty("completion-enable-autopopup", completionEnablePopup);
        int completionPopupDelay = options.getCompletionPopupDelay();
        properties.putIntegerProperty("completion-popup-delay", completionPopupDelay);
        boolean parameterEnablePopup = options.isParamaterPopupEnabled();
        properties.putBooleanProperty("parameter-enable-autopopup", parameterEnablePopup);
        int parameterPopupDelay = options.getParameterPopupDelay();
        properties.putIntegerProperty("parameter-popup-delay", parameterPopupDelay);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        JLabel label;
        JSlider slider;
        Object source = event.getSource();
        if (source == this.slider_completionPopupDelay) {
            slider = this.slider_completionPopupDelay;
            label = this.label_completionPopupDelayText;
        } else if (source == this.slider_parameterPopupDelay) {
            slider = this.slider_parameterPopupDelay;
            label = this.label_parameterPopupDelayText;
        } else {
            throw new IllegalStateException("unknown source");
        }
        float value = (float)slider.getValue() / 10.0f;
        String valueStr = InsightOptionsBundle.format("LABEL_SLIDER_SECONDS_TOOLTIP", this.numberFormatter.format(value));
        label.setText(valueStr);
        slider.setToolTipText(valueStr);
    }

    void loadSettingsFrom(InsightOptions options) {
        boolean completionEnablePopup = options.isCompletePopupEnabled();
        int completionPopupDelay = options.getCompletionPopupDelay();
        boolean parameterEnablePopup = options.isParamaterPopupEnabled();
        int parameterPopupDelay = options.getParameterPopupDelay();
        this.checkbox_completionEnablePopup.setSelected(completionEnablePopup);
        this.slider_completionPopupDelay.setValue(completionPopupDelay / 100);
        this.checkbox_parameterEnablePopup.setSelected(parameterEnablePopup);
        this.slider_parameterPopupDelay.setValue(parameterPopupDelay / 100);
    }

    void saveSettingsTo(InsightOptions options) {
        boolean completionEnablePopup = this.checkbox_completionEnablePopup.isSelected();
        int completionPopupDelay = this.slider_completionPopupDelay.getValue() * 100;
        boolean parameterEnablePopup = this.checkbox_parameterEnablePopup.isSelected();
        int parameterPopupDelay = this.slider_parameterPopupDelay.getValue() * 100;
        options.setCompletePopupEnabled(completionEnablePopup);
        options.setCompletionPopupDelay(completionPopupDelay);
        options.setParamaterPopupEnabled(parameterEnablePopup);
        options.setParameterPopupDelay(parameterPopupDelay);
    }

    private void initializeComponent() {
        this.numberFormatter = NumberFormat.getNumberInstance();
        this.numberFormatter.setMinimumFractionDigits(1);
        this.numberFormatter.setMaximumFractionDigits(1);
        String completionEnablePopupText = InsightOptionsBundle.get("LABEL_COMPLETION_ENABLE_AUTOPOPUP");
        this.checkbox_completionEnablePopup = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_completionEnablePopup, (String)completionEnablePopupText);
        String completionPopupDelayText = InsightOptionsBundle.get("LABEL_COMPLETION_AUTOPOPUP_DELAY");
        JLabel label_completionPopupDelay = new JLabel();
        this.slider_completionPopupDelay = new JSlider(1, 30, 10);
        this.slider_completionPopupDelay.addChangeListener(this);
        this.label_completionPopupDelayText = new JLabel();
        ResourceUtils.resLabel((JLabel)label_completionPopupDelay, (Component)this.slider_completionPopupDelay, (String)completionPopupDelayText);
        String completionPopupMinText = InsightOptionsBundle.get("LABEL_SLIDER_FASTER");
        this.label_completionSliderMin = new JLabel(completionPopupMinText);
        String completionPopupMaxText = InsightOptionsBundle.get("LABEL_SLIDER_SLOWER");
        this.label_completionSliderMax = new JLabel(completionPopupMaxText);
        this.slider_completionPopupDelay.setPaintLabels(false);
        this.slider_completionPopupDelay.setPaintTicks(true);
        this.slider_completionPopupDelay.setMajorTickSpacing(10);
        this.slider_completionPopupDelay.setMinorTickSpacing(1);
        this.slider_completionPopupDelay.setSnapToTicks(true);
        Component[] completionDependents = new Component[]{this.slider_completionPopupDelay, label_completionPopupDelay, this.label_completionPopupDelayText, this.label_completionSliderMin, this.label_completionSliderMax};
        ItemSelectableTracker completionTracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_completionEnablePopup, completionDependents);
        this.checkbox_completionEnablePopup.addItemListener((ItemListener)completionTracker);
        String parameterEnablePopupText = InsightOptionsBundle.get("LABEL_PARAMETER_ENABLE_AUTOPOPUP");
        this.checkbox_parameterEnablePopup = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_parameterEnablePopup, (String)parameterEnablePopupText);
        String parameterPopupDelayText = InsightOptionsBundle.get("LABEL_PARAMETER_AUTOPOPUP_DELAY");
        JLabel label_parameterPopupDelay = new JLabel();
        this.slider_parameterPopupDelay = new JSlider(1, 30, 10);
        this.slider_parameterPopupDelay.addChangeListener(this);
        this.label_parameterPopupDelayText = new JLabel();
        ResourceUtils.resLabel((JLabel)label_parameterPopupDelay, (Component)this.slider_parameterPopupDelay, (String)parameterPopupDelayText);
        String paramPopupMinText = InsightOptionsBundle.get("LABEL_SLIDER_FASTER");
        this.label_parameterSliderMin = new JLabel(paramPopupMinText);
        String paramPopupMaxText = InsightOptionsBundle.get("LABEL_SLIDER_SLOWER");
        this.label_parameterSliderMax = new JLabel(paramPopupMaxText);
        this.slider_parameterPopupDelay.setPaintLabels(false);
        this.slider_parameterPopupDelay.setPaintTicks(true);
        this.slider_parameterPopupDelay.setMajorTickSpacing(10);
        this.slider_parameterPopupDelay.setMinorTickSpacing(1);
        this.slider_parameterPopupDelay.setSnapToTicks(true);
        Component[] parameterDependents = new Component[]{this.slider_parameterPopupDelay, label_parameterPopupDelay, this.label_parameterPopupDelayText, this.label_parameterSliderMin, this.label_parameterSliderMax};
        ItemSelectableTracker parameterTracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_parameterEnablePopup, parameterDependents);
        this.checkbox_parameterEnablePopup.addItemListener((ItemListener)parameterTracker);
        this.slider_completionPopupDelay.setValue(1);
        this.slider_parameterPopupDelay.setValue(1);
        this.setLayout((LayoutManager)new MigLayout("ins 0"));
        this.add(this.checkbox_completionEnablePopup, "span, wrap, gaptop 10px");
        this.add(label_completionPopupDelay, "span, wrap");
        this.add(this.label_completionSliderMin, "span, split, aligny center");
        this.add(this.slider_completionPopupDelay, "");
        this.add(this.label_completionSliderMax, "aligny center, wrap");
        this.add(this.label_completionPopupDelayText, "span, alignx center, wrap");
        this.add(this.checkbox_parameterEnablePopup, "span, wrap, gaptop 10px");
        this.add(label_parameterPopupDelay, "wrap");
        this.add(this.label_parameterSliderMin, "span, aligny center, split");
        this.add(this.slider_parameterPopupDelay, "");
        this.add(this.label_parameterSliderMax, "aligny center, wrap");
        this.add(this.label_parameterPopupDelayText, "span, alignx center, wrap");
    }
}

