/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.ide.insight.InsightItem;
import oracle.ide.insight.filter.InsightSorter;

public final class DefaultInsightSorter<T extends InsightItem>
implements InsightSorter<T> {
    String prefix = "a";
    private final Comparator<InsightItem> DEFAULT_COMPARATOR = new Comparator<InsightItem>(){

        @Override
        public int compare(InsightItem itemA, InsightItem itemB) {
            if (itemA == itemB) {
                return 0;
            }
            if (itemA.getGroup() != itemB.getGroup()) {
                return itemA.getGroup() < itemB.getGroup() ? -1 : 1;
            }
            String nameA = itemA.getName();
            String nameB = itemB.getName();
            if (DefaultInsightSorter.this.prefix != null) {
                if (nameA.startsWith(DefaultInsightSorter.this.prefix) && !nameB.startsWith(DefaultInsightSorter.this.prefix)) {
                    return -1;
                }
                if (!nameA.startsWith(DefaultInsightSorter.this.prefix) && nameB.startsWith(DefaultInsightSorter.this.prefix)) {
                    return 1;
                }
            }
            if (itemA.getWeight() != itemB.getWeight()) {
                return itemA.getWeight() < itemB.getWeight() ? -1 : 1;
            }
            nameA = nameA.toLowerCase();
            nameB = nameB.toLowerCase();
            if (DefaultInsightSorter.this.prefix != null) {
                if (nameA.startsWith(DefaultInsightSorter.this.prefix) && !nameB.startsWith(DefaultInsightSorter.this.prefix)) {
                    return -1;
                }
                if (!nameA.startsWith(DefaultInsightSorter.this.prefix) && nameB.startsWith(DefaultInsightSorter.this.prefix)) {
                    return 1;
                }
            }
            return nameA.compareTo(nameB);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sort(List<T> items, String prefix) {
        this.prefix = prefix == null || prefix.length() == 0 ? null : prefix.toLowerCase();
        List<T> list = items;
        synchronized (list) {
            ArrayList<T> sortList = new ArrayList<T>(items);
            Collections.sort(sortList, this.DEFAULT_COMPARATOR);
            items.clear();
            items.addAll(sortList);
        }
    }
}

