/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.completion.ui;

import java.lang.ref.WeakReference;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import javax.swing.SwingWorker;
import javax.swing.text.JTextComponent;
import oracle.ide.Context;
import oracle.ide.ceditor.insight.InsightBundle;
import oracle.ide.insight.InsightActionListener;
import oracle.ide.insight.InsightItem;
import oracle.ide.insight.completion.CompletionContext;
import oracle.ide.insight.completion.HtmlDetailItem;
import oracle.ide.insight.completion.ui.DetailView;
import oracle.javatools.editor.popup.HtmlContentProvider;
import oracle.javatools.editor.popup.HtmlPopupView;
import oracle.javatools.editor.popup.StaticHtmlContentProvider;

public final class HtmlDetailView
implements DetailView {
    private WeakReference<DetailWorker> contentProviderWorker;
    private HtmlPopupView htmlPopupView = new HtmlPopupView(emptyProvider);
    private static HtmlContentProvider emptyProvider = new StaticHtmlContentProvider(InsightBundle.get((String)"INSIGHT_DOC_NO_INFORMATION_AVAILABLE"), true);
    private Listeners listeners;

    public HtmlDetailView() {
        if (this.htmlPopupView != null) {
            this.htmlPopupView.setToolbarVisible(false);
            this.htmlPopupView.setBorder(null);
        }
        this.listeners = new Listeners();
    }

    @Override
    public JComponent getDetailComponent() {
        return this.htmlPopupView;
    }

    public void itemSelected(CompletionContext completionContext, InsightItem item) {
        DetailWorker detailWorker;
        DetailWorker detailWorker2 = detailWorker = this.contentProviderWorker == null ? null : (DetailWorker)this.contentProviderWorker.get();
        if (detailWorker != null) {
            try {
                this.contentProviderWorker.clear();
                detailWorker.cancel(false);
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
        }
        if (item instanceof HtmlDetailItem) {
            HtmlDetailItem contentProviderItem = (HtmlDetailItem)((Object)item);
            Object support = completionContext.getSupport();
            Context context = support.getContext();
            detailWorker = new DetailWorker(contentProviderItem, context);
            this.contentProviderWorker = new WeakReference<DetailWorker>(detailWorker);
            detailWorker.execute();
        }
    }

    @Override
    public void shown(CompletionContext completionContext) {
        completionContext.getAdapter().addInsightActionListener(this.listeners);
    }

    @Override
    public void hidden(CompletionContext completionContext) {
        completionContext.getAdapter().removeInsightActionListener(this.listeners);
        this.htmlPopupView = null;
    }

    private class Listeners
    implements InsightActionListener {
        private Listeners() {
        }

        public boolean insightActionPerformed(InsightActionListener.Action action, JTextComponent textComponent) {
            if (HtmlDetailView.this.htmlPopupView != null) {
                if (action == InsightActionListener.Action.SCROLL_DOC_UP) {
                    HtmlDetailView.this.htmlPopupView.up();
                } else if (action == InsightActionListener.Action.SCROLL_DOC_DOWN) {
                    HtmlDetailView.this.htmlPopupView.down();
                } else {
                    return false;
                }
            }
            return true;
        }
    }

    private class DetailWorker
    extends SwingWorker<HtmlContentProvider, Object> {
        private final HtmlDetailItem contentProviderItem;
        private final Context context;

        DetailWorker(HtmlDetailItem contentProviderItem, Context context) {
            this.context = context;
            this.contentProviderItem = contentProviderItem;
        }

        @Override
        protected HtmlContentProvider doInBackground() throws Exception {
            return this.contentProviderItem.getContentProvider(this.context);
        }

        @Override
        protected void done() {
            HtmlContentProvider contentProvider = null;
            if (!this.isCancelled()) {
                try {
                    contentProvider = (HtmlContentProvider)this.get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
            }
            if (contentProvider == null) {
                contentProvider = emptyProvider;
            }
            if (HtmlDetailView.this.htmlPopupView != null) {
                HtmlDetailView.this.htmlPopupView.push(contentProvider);
            }
        }
    }
}

