/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.completion;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import oracle.ide.insight.completion.CompletionContext;
import oracle.ide.insight.completion.CompletionSupport;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.TextTabber;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;

public final class CompletionUtils {
    private static final String PARAM_SEPARATOR = ",";

    private CompletionUtils() {
    }

    public static void insertParameterList(final CompletionContext<CompletionSupport> completionContext, JTextComponent textComponent, List<String> parameters, boolean insertParentheses) throws BadLocationException {
        StringBuffer sb = new StringBuffer();
        if (insertParentheses) {
            sb.append("(");
        }
        Iterator<String> it = parameters.iterator();
        CodingStyleOptions styleOptions = CodingStyleManager.getCodingStyleManager().getCodingStyleOptions();
        String separator = PARAM_SEPARATOR;
        if (styleOptions.getSpaceBeforeComma()) {
            separator = " " + separator;
        }
        if (styleOptions.getSpaceAfterComma()) {
            separator = separator + " ";
        }
        if (styleOptions.getSpaceWithinParenthesis()) {
            sb.append(" ");
        }
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(separator);
        }
        if (styleOptions.getSpaceWithinParenthesis()) {
            sb.append(" ");
        }
        if (insertParentheses) {
            sb.append(")");
        }
        int insertPos = textComponent.getCaretPosition();
        textComponent.getDocument().insertString(insertPos, sb.toString(), null);
        if (textComponent instanceof BasicEditorPane) {
            boolean showParameterInsight = false;
            if (parameters.size() == 1) {
                int selStart;
                int n = selStart = styleOptions.getSpaceWithinParenthesis() ? insertPos + 1 : insertPos;
                if (insertParentheses) {
                    ++selStart;
                }
                textComponent.setCaretPosition(selStart + parameters.get(0).length());
                textComponent.moveCaretPosition(selStart);
                showParameterInsight = true;
            } else if (parameters.size() > 1) {
                final TextTabber textTabber = new TextTabber((BasicEditorPane)textComponent);
                int paramPos = insertPos;
                if (styleOptions.getSpaceWithinParenthesis()) {
                    ++paramPos;
                }
                if (insertParentheses) {
                    ++paramPos;
                }
                for (String parameter : parameters) {
                    textTabber.addRange(paramPos, paramPos + parameter.length());
                    paramPos += parameter.length() + separator.length();
                }
                textTabber.setValidRange(insertPos, insertPos + sb.length());
                textTabber.setValidRange(insertPos, insertPos + sb.length());
                textTabber.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getPropertyName().equals("PROPERTY_ACTIVE") && evt.getNewValue() == Boolean.FALSE) {
                            completionContext.getController().hide();
                            textTabber.removePropertyChangeListener((PropertyChangeListener)this);
                        } else if (evt.getPropertyName().equals("PROPERTY_RANGE_CHANGE_PENDING")) {
                            completionContext.getController().hide();
                        } else if (evt.getPropertyName().equals("PROPERTY_RANGE_CHANGE")) {
                            CompletionSupport completionSupport = (CompletionSupport)completionContext.getSupport();
                            CompletionContext<CompletionSupport> autoContext = new CompletionContext<CompletionSupport>(completionSupport, CompletionContext.Invoked.AUTO, completionContext.getMultiProvider());
                            completionContext.getController().show(autoContext);
                        }
                    }
                });
                completionContext.getController().hide();
                textTabber.setActive(true);
                showParameterInsight = true;
            }
        } else {
            int selStart;
            int n = selStart = styleOptions.getSpaceWithinParenthesis() ? insertPos + 1 : insertPos;
            if (insertParentheses) {
                ++selStart;
            }
            textComponent.setCaretPosition(selStart);
        }
    }
}

