/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v11.ac;

import oracle.security.xmlsec.liberty.v11.LibertyInitializer;
import oracle.security.xmlsec.liberty.v11.ac.AuthenticationContextException;
import oracle.security.xmlsec.liberty.v11.ac.AuthenticationContextStatement;
import oracle.security.xmlsec.liberty.v11.ac.Generation;
import oracle.security.xmlsec.liberty.v11.ac.TimeSyncToken;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.util.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TimeSyncTokenClass
extends AuthenticationContextStatement {
    public TimeSyncTokenClass(Element element) {
        super(element);
    }

    public TimeSyncTokenClass(Element element, String systemId) {
        super(element, systemId);
    }

    public TimeSyncTokenClass(Document owner) {
        super(owner);
    }

    public TimeSyncTokenClass(Document owner, String id) throws AuthenticationContextException {
        this(owner);
        this.setID(id);
    }

    @Override
    protected void initialize() {
        this.setValidElement("http://projectliberty.org/schemas/authctx/2002/05", "AuthenticationMethod", "http://projectliberty.org/schemas/authctx/2002/05", "AuthenticationContextStatement");
        this.setValidElement("http://projectliberty.org/schemas/authctx/2002/05", "PrincipalAuthenticationMechanism", "http://projectliberty.org/schemas/authctx/2002/05", "AuthenticationMethod");
        this.setValidElement("http://projectliberty.org/schemas/authctx/2002/05", "Token", "http://projectliberty.org/schemas/authctx/2002/05", "PrincipalAuthenticationMechanism");
        this.setValidElement("http://projectliberty.org/schemas/authctx/2002/05", "TimeSyncToken", "http://projectliberty.org/schemas/authctx/2002/05", "Token");
        this.setValidElement("http://projectliberty.org/schemas/authctx/2002/05", "Generation", "http://projectliberty.org/schemas/authctx/2002/05", "TimeSyncToken");
        this.setClassName("Time-Sync-Token");
        this.setAssociatedURI("http://www.projectliberty.org/schemas/authctx/classes/Time-Sync-Token");
    }

    @Override
    protected boolean isValidAttributeValue(String value, String attrName, String attrNSURI, XMLElement element) {
        if (attrName.equals("mechanism") && attrNSURI.equals("http://projectliberty.org/schemas/authctx/2002/05") && element instanceof Generation && !value.equals("principalchosen")) {
            return false;
        }
        if (attrName.equals("deviceType") && attrNSURI.equals("http://projectliberty.org/schemas/authctx/2002/05") && element instanceof TimeSyncToken && !value.equals("hardware")) {
            return false;
        }
        if (attrName.equals("seedLength") && attrNSURI.equals("http://projectliberty.org/schemas/authctx/2002/05") && element instanceof TimeSyncToken) {
            try {
                int i = Integer.parseInt(value);
                if (i != 64) {
                    return false;
                }
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        if (attrName.equals("deviceInHand") && attrNSURI.equals("http://projectliberty.org/schemas/authctx/2002/05") && element instanceof TimeSyncToken && !value.equals("true")) {
            return false;
        }
        return super.isValidAttributeValue(value, attrName, attrNSURI, element);
    }

    static {
        SAMLInitializer.initialize();
        LibertyInitializer.initialize();
    }
}

