/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v11.ac;

import oracle.security.xmlsec.liberty.v11.LibertyInitializer;
import oracle.security.xmlsec.liberty.v11.ac.ACElement;
import oracle.security.xmlsec.liberty.v11.ac.AuthenticationContextException;
import oracle.security.xmlsec.liberty.v11.ac.AuthenticationContextStatement;
import oracle.security.xmlsec.saml.SAMLInitializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TimeSyncToken
extends ACElement {
    public static final String HARDWARE = "hardware";
    public static final String SOFTWARE = "software";

    public TimeSyncToken(Element element, AuthenticationContextStatement acs) {
        super(element, acs);
    }

    public TimeSyncToken(Element element, String systemId, AuthenticationContextStatement acs) {
        super(element, systemId, acs);
    }

    public TimeSyncToken(Document owner, AuthenticationContextStatement acs) {
        super(owner, "http://projectliberty.org/schemas/authctx/2002/05", "TimeSyncToken", acs);
    }

    public TimeSyncToken(Document owner, AuthenticationContextStatement acs, String deviceType, int seedLength, boolean deviceInHand) throws AuthenticationContextException {
        this(owner, acs);
        this.setDeviceType(deviceType);
        this.setSeedLength(seedLength);
        this.setDeviceInHand(deviceInHand);
    }

    public void setDeviceType(String deviceType) throws AuthenticationContextException {
        this.authenticationContextClass.validateAttributeValue(deviceType, "deviceType", "http://projectliberty.org/schemas/authctx/2002/05", this);
        this.setAttribute("deviceType", deviceType);
    }

    public String getDeviceType() {
        if (this.hasAttribute("deviceType")) {
            return this.getAttribute("deviceType");
        }
        return null;
    }

    public void setSeedLength(int seedLength) throws AuthenticationContextException {
        this.authenticationContextClass.validateAttributeValue("" + seedLength, "seedLength", "http://projectliberty.org/schemas/authctx/2002/05", this);
        this.setAttribute("seedLength", Integer.toString(seedLength));
    }

    public Integer getSeedLength() {
        if (this.hasAttribute("seedLength")) {
            return new Integer(this.getAttribute("seedLength"));
        }
        return null;
    }

    public void setDeviceInHand(boolean deviceInHand) throws AuthenticationContextException {
        this.authenticationContextClass.validateAttributeValue("" + deviceInHand, "deviceInHand", "http://projectliberty.org/schemas/authctx/2002/05", this);
        this.setAttribute("deviceInHand", new Boolean(deviceInHand).toString());
    }

    public Boolean getDeviceInHand() {
        if (this.hasAttribute("deviceInHand")) {
            return new Boolean(this.getAttribute("deviceInHand"));
        }
        return null;
    }

    static {
        SAMLInitializer.initialize();
        LibertyInitializer.initialize();
    }
}

