/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v11.ac;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import oracle.security.xmlsec.liberty.v11.LibertyInitializer;
import oracle.security.xmlsec.liberty.v11.ac.ACElement;
import oracle.security.xmlsec.liberty.v11.ac.AuthenticationContextException;
import oracle.security.xmlsec.liberty.v11.ac.AuthenticationContextStatement;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.TagManager;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class LibertyUtils {
    LibertyUtils() {
    }

    static String collectTextFromChild(XMLElement contextElement, String namespaceURI, String localName) {
        NodeList list = XMLElement.getChildElementsByTagNameNS((Element)((Element)contextElement.getNode()), (String)namespaceURI, (String)localName);
        if (list.getLength() > 0) {
            return XMLUtils.collectText((Node)list.item(0));
        }
        return null;
    }

    static List collectTextFromChildren(XMLElement contextElement, String namespaceURI, String localName) {
        NodeList list = XMLElement.getChildElementsByTagNameNS((Element)((Element)contextElement.getNode()), (String)namespaceURI, (String)localName);
        ArrayList<String> result = new ArrayList<String>(list.getLength());
        int n = list.getLength();
        for (int i = 0; i < n; ++i) {
            result.add(XMLUtils.collectText((Node)list.item(i)));
        }
        return result;
    }

    static void insertChildElementWithText(XMLElement contextElement, String namespaceURI, String localName, String[] namespaceURIs, String[] localNames, String text, boolean replaceExisting) throws DOMException {
        Document doc = contextElement.getOwnerDocument();
        Element child = doc.createElementNS(namespaceURI, localName);
        child.appendChild(doc.createTextNode(text));
        XMLUtils.copyNSPrefix((Element)((Element)contextElement.getNode()), (Element)child);
        if (replaceExisting) {
            XMLUtils.removeChildren((Element)((Element)contextElement.getNode()), (String)namespaceURI, (String)localName);
        }
        XMLUtils.insertChild((Element)((Element)contextElement.getNode()), (Element)child, (String[])namespaceURIs, (String[])localNames);
    }

    static ACElement getChildACElement(XMLElement contextElement, String localName, AuthenticationContextStatement acs) {
        ACElement element = null;
        NodeList nList = contextElement.getChildElementsByTagNameNS("http://projectliberty.org/schemas/authctx/2002/05", localName);
        if (nList.getLength() != 0) {
            element = LibertyUtils.getInstance((Element)nList.item(0), localName, "http://projectliberty.org/schemas/authctx/2002/05", acs, contextElement.getSystemId());
        }
        return element;
    }

    static List getChildACElements(XMLElement contextElement, String localName, AuthenticationContextStatement acs) {
        NodeList nList = contextElement.getChildElementsByTagNameNS("http://projectliberty.org/schemas/authctx/2002/05", localName);
        ArrayList<ACElement> result = new ArrayList<ACElement>(nList.getLength());
        int n = nList.getLength();
        for (int i = 0; i < n; ++i) {
            ACElement element = LibertyUtils.getInstance((Element)nList.item(i), localName, "http://projectliberty.org/schemas/authctx/2002/05", acs, contextElement.getSystemId());
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    static void setChildACElement(XMLElement contextElement, ACElement element, String[] nsURIs, String[] localNames) throws AuthenticationContextException {
        if (contextElement instanceof ACElement) {
            ((ACElement)contextElement).getAuthenticationContextClass().validateElement(element, contextElement);
        }
        XMLUtils.removeChildren((Element)((Element)contextElement.getNode()), (String)element.getNamespaceURI(), (String)element.getLocalName());
        LibertyUtils.addChildACElement(contextElement, element, nsURIs, localNames);
    }

    static void addChildACElement(XMLElement contextElement, ACElement element, String[] nsURIs, String[] localNames) throws AuthenticationContextException {
        if (contextElement instanceof ACElement) {
            ((ACElement)contextElement).getAuthenticationContextClass().validateElement(element, contextElement);
        }
        XMLUtils.insertChild((XMLElement)contextElement, (XMLElement)element, (String[])nsURIs, (String[])localNames);
    }

    private static ACElement getInstance(Element element, String tag, String ns, AuthenticationContextStatement acs, String systemId) {
        ACElement result = null;
        try {
            Class c;
            if (tag == null) {
                tag = QName.getLocalPart((String)element.getNodeName());
            }
            if (ns == null) {
                ns = XMLUtils.getNamespaceURI((Node)element);
            }
            if (tag != null && ns != null && (c = TagManager.getTagManager().getClassForTag(ns, tag)) != null) {
                Constructor x = c.getConstructor(Element.class, AuthenticationContextStatement.class);
                result = (ACElement)((Object)x.newInstance(new Object[]{element, acs}));
                result.setSystemId(systemId);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return result;
    }

    static {
        SAMLInitializer.initialize();
        LibertyInitializer.initialize();
    }
}

