/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v11.ac;

import oracle.security.xmlsec.liberty.v11.LibertyInitializer;
import oracle.security.xmlsec.liberty.v11.ac.ACElement;
import oracle.security.xmlsec.liberty.v11.ac.AuthenticationContextException;
import oracle.security.xmlsec.liberty.v11.ac.AuthenticationContextStatement;
import oracle.security.xmlsec.saml.SAMLInitializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Generation
extends ACElement {
    public static final String PRINCIPAL_CHOSEN = "principalchosen";
    public static final String AUTOMATIC = "automatic";

    public Generation(Element element, AuthenticationContextStatement acs) {
        super(element, acs);
    }

    public Generation(Element element, String systemId, AuthenticationContextStatement acs) {
        super(element, systemId, acs);
    }

    public Generation(Document owner, AuthenticationContextStatement acs) {
        super(owner, "http://projectliberty.org/schemas/authctx/2002/05", "Generation", acs);
    }

    public Generation(Document owner, AuthenticationContextStatement acs, String mechanism) throws AuthenticationContextException {
        this(owner, acs);
        this.setMechanism(mechanism);
    }

    public void setMechanism(String mechanism) throws AuthenticationContextException {
        this.authenticationContextClass.validateAttributeValue(mechanism, "mechanism", "http://projectliberty.org/schemas/authctx/2002/05", this);
        this.setAttribute("mechanism", mechanism);
    }

    public String getMechanism() {
        if (this.hasAttribute("mechanism")) {
            return this.getAttribute("mechanism");
        }
        return null;
    }

    static {
        SAMLInitializer.initialize();
        LibertyInitializer.initialize();
    }
}

