/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v11;

import java.net.URLEncoder;
import java.security.PrivateKey;
import java.util.Date;
import oracle.security.xmlsec.dsig.SigningException;
import oracle.security.xmlsec.dsig.XSSignature;
import oracle.security.xmlsec.liberty.v11.LibDSigUtils;
import oracle.security.xmlsec.liberty.v11.LibertyInitializer;
import oracle.security.xmlsec.liberty.v11.LibertyUtils;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.saml.SAMLMessage;
import oracle.security.xmlsec.samlp.ResponseType;
import oracle.security.xmlsec.samlp.Status;
import oracle.security.xmlsec.samlp.StatusCode;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class LibResponseMessage
extends ResponseType {
    public static final String NO_AVAILABLE_IDP = "NoAvailableIDP";
    public static final String NO_SUPPORTED_IDP = "NoSupportedIDP";
    public static final String UNSUPPORTED_PROFILE = "UnsupportedProfile";

    protected LibResponseMessage(Element element) throws DOMException {
        super(element);
    }

    protected LibResponseMessage(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    protected LibResponseMessage(Document owner, String nsURI, String localName) throws DOMException {
        super(owner, nsURI, localName);
    }

    protected LibResponseMessage(Document owner, String nsURI, String localName, String responseID, Date issueInstant) throws DOMException {
        this(owner, nsURI, localName);
        this.setResponseID(responseID);
        this.setIssueInstant(issueInstant);
    }

    public static LibResponseMessage getInstance(Element element) throws DOMException {
        return (LibResponseMessage)XMLUtils.getInstance((Element)element, null, (String)"http://projectliberty.org/schemas/core/2002/12");
    }

    public void setId(String id) throws DOMException {
        this.setAttribute("id", id);
    }

    public String getId() {
        if (this.hasAttribute("id")) {
            return this.getAttribute("id");
        }
        return null;
    }

    public void setProviderID(String providerID) {
        LibertyUtils.insertChildElementWithText((XMLElement)this, "http://projectliberty.org/schemas/core/2002/12", "ProviderID", this.getChildElementsNSURIs(), this.getChildElementsLocalNames(), providerID, true);
    }

    public String getProviderID() {
        return LibertyUtils.collectTextFromChild((XMLElement)this, "http://projectliberty.org/schemas/core/2002/12", "ProviderID");
    }

    public void setStatus(Status status) {
        LibertyUtils.setChildElement((XMLElement)this, (XMLElement)status, this.getChildElementsNSURIs(), this.getChildElementsLocalNames());
    }

    public Status getStatus() {
        return (Status)LibertyUtils.getChildElement((XMLElement)this, "urn:oasis:names:tc:SAML:1.0:protocol", "Status");
    }

    public void setRelayState(String value) {
        LibertyUtils.insertChildElementWithText((XMLElement)this, "http://projectliberty.org/schemas/core/2002/12", "RelayState", this.getChildElementsNSURIs(), this.getChildElementsLocalNames(), value, true);
    }

    public String getRelayState() {
        return LibertyUtils.collectTextFromChild((XMLElement)this, "http://projectliberty.org/schemas/core/2002/12", "RelayState");
    }

    public XSSignature addSignature(String signatureMethod, String c14nMethod) {
        return this.addSignature(signatureMethod, c14nMethod, "http://www.w3.org/2000/09/xmldsig#sha1");
    }

    public XSSignature addSignature(String signatureMethod, String c14nMethod, String digestMethod) {
        String id = this.getId();
        if (id == null || id.length() == 0) {
            return super.addSignature(signatureMethod, c14nMethod, digestMethod);
        }
        this.clearSignature();
        return LibDSigUtils.addSignature((SAMLMessage)this, id, signatureMethod, c14nMethod, digestMethod, this.getNSURIsPrecedeDSig(), this.getLocalNamesPrecedeDSig());
    }

    protected abstract String[] getChildElementsNSURIs();

    protected abstract String[] getChildElementsLocalNames();

    protected int getChildElementPosition(String nsURI, String localName) throws DOMException {
        String[] localNames = this.getChildElementsLocalNames();
        String[] nsURIs = this.getChildElementsNSURIs();
        int pos = 0;
        while (!localName.equals(localNames[pos]) || !nsURI.equals(nsURIs[pos])) {
            if (pos >= localNames.length) {
                throw new DOMException(9, "The element with the local name " + localName + "in the namespace " + nsURI + "is not a valid child element specified in the schema for this element");
            }
            ++pos;
        }
        return pos;
    }

    String toURLEncodedString(PrivateKey key, String sigAlg) throws SigningException {
        int last;
        String relayState;
        String value;
        StatusCode sc;
        Status status;
        String recipient;
        String providerID;
        String inResponseTo;
        StringBuffer queryBuffer = new StringBuffer();
        String responseID = this.getResponseID();
        if (responseID != null) {
            queryBuffer.append("ResponseID");
            queryBuffer.append("=");
            queryBuffer.append(URLEncoder.encode(responseID));
            queryBuffer.append('&');
        }
        if ((inResponseTo = this.getInResponseTo()) != null) {
            queryBuffer.append("InResponseTo");
            queryBuffer.append("=");
            queryBuffer.append(URLEncoder.encode(inResponseTo));
            queryBuffer.append('&');
        }
        queryBuffer.append("MajorVersion");
        queryBuffer.append("=1&");
        queryBuffer.append("MinorVersion");
        queryBuffer.append("=0&");
        Date issueInstant = this.getIssueInstant();
        if (issueInstant != null) {
            queryBuffer.append("IssueInstant");
            queryBuffer.append("=");
            queryBuffer.append(URLEncoder.encode(XMLUtils.formatDateTime((Date)issueInstant)));
            queryBuffer.append('&');
        }
        if ((providerID = this.getProviderID()) != null) {
            queryBuffer.append("ProviderID");
            queryBuffer.append("=");
            queryBuffer.append(URLEncoder.encode(providerID));
            queryBuffer.append('&');
        }
        if ((recipient = this.getRecipient()) != null) {
            queryBuffer.append("Recipient");
            queryBuffer.append("=");
            queryBuffer.append(URLEncoder.encode(recipient));
            queryBuffer.append('&');
        }
        if ((status = this.getStatus()) != null && (sc = status.getStatusCode()) != null && (value = sc.getValue()) != null) {
            queryBuffer.append("Value");
            queryBuffer.append("=");
            queryBuffer.append(URLEncoder.encode(value));
            while ((sc = sc.getStatusCode()) != null) {
                value = sc.getValue();
                if (value == null) continue;
                queryBuffer.append(URLEncoder.encode(" "));
                queryBuffer.append(URLEncoder.encode(sc.getValue()));
            }
            queryBuffer.append('&');
        }
        if ((relayState = this.getRelayState()) != null) {
            queryBuffer.append("RelayState");
            queryBuffer.append("=");
            queryBuffer.append(URLEncoder.encode(relayState));
            queryBuffer.append('&');
        }
        if (key != null && sigAlg != null) {
            queryBuffer.append("SigAlg");
            queryBuffer.append("=");
            queryBuffer.append(URLEncoder.encode(sigAlg));
            String toBeSigned = queryBuffer.toString();
            String sigValue = LibDSigUtils.signURL(toBeSigned, key, sigAlg);
            queryBuffer.append("&");
            queryBuffer.append("Signature");
            queryBuffer.append("=");
            queryBuffer.append(sigValue);
        }
        if ((last = queryBuffer.length() - 1) >= 0 && queryBuffer.charAt(last) == '&') {
            queryBuffer.deleteCharAt(last);
        }
        return queryBuffer.toString();
    }

    static {
        SAMLInitializer.initialize();
        LibertyInitializer.initialize();
    }
}

