/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v11;

import java.util.Date;
import java.util.List;
import java.util.Vector;
import oracle.security.xmlsec.liberty.v11.LibAssertion;
import oracle.security.xmlsec.liberty.v11.LibResponseMessage;
import oracle.security.xmlsec.liberty.v11.LibertyInitializer;
import oracle.security.xmlsec.saml.Assertion;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AuthnResponse
extends LibResponseMessage {
    public AuthnResponse(Element element) throws DOMException {
        super(element);
    }

    public AuthnResponse(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public AuthnResponse(Document owner) throws DOMException {
        super(owner, "http://projectliberty.org/schemas/core/2002/12", "AuthnResponse");
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://projectliberty.org/schemas/core/2002/12");
        this.addNSPrefixAttrDefault("http://projectliberty.org/schemas/core/2002/12");
        this.addNSPrefixAttrDefault("http://projectliberty.org/schemas/authctx/2002/05");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:1.0:protocol");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:1.0:assertion");
    }

    public AuthnResponse(Document owner, String responseId, Date issueInstant, String providerId) {
        this(owner);
        this.setResponseID(responseId);
        this.setIssueInstant(issueInstant);
        this.setProviderID(providerId);
    }

    public void addAssertion(Assertion assertion) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)assertion, (String[])this.getChildElementsNSURIs(), (String[])this.getChildElementsLocalNames());
    }

    public List getAssertions() {
        Vector<LibAssertion> vec = new Vector<LibAssertion>();
        NodeList list = this.getChildElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            vec.addElement(new LibAssertion((Element)list.item(i), this.systemId));
        }
        return vec;
    }

    @Override
    protected String[] getChildElementsNSURIs() {
        return new String[]{"http://www.w3.org/2000/09/xmldsig#", "urn:oasis:names:tc:SAML:1.0:protocol", "urn:oasis:names:tc:SAML:1.0:assertion", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12"};
    }

    @Override
    protected String[] getChildElementsLocalNames() {
        return new String[]{"Signature", "Status", "Assertion", "ProviderID", "RelayState"};
    }

    static {
        SAMLInitializer.initialize();
        LibertyInitializer.initialize();
    }
}

