/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v11;

import oracle.security.xmlsec.liberty.v11.AuthnRequest;
import oracle.security.xmlsec.liberty.v11.IDPList;
import oracle.security.xmlsec.liberty.v11.LibertyInitializer;
import oracle.security.xmlsec.liberty.v11.LibertyUtils;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.util.XMLElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AuthnRequestEnvelope
extends XMLElement {
    private static final String[] nsURIs = new String[]{"http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12"};
    private static final String[] localNames = new String[]{"AuthnRequest", "ProviderID", "ProviderName", "AssertionConsumerServiceURL", "IDPList", "IsPassive"};

    public AuthnRequestEnvelope(Element element) throws DOMException {
        super(element);
    }

    public AuthnRequestEnvelope(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public AuthnRequestEnvelope(Document owner) throws DOMException {
        super(owner, "http://projectliberty.org/schemas/core/2002/12", "AuthnRequestEnvelope");
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://projectliberty.org/schemas/core/2002/12");
        this.addNSPrefixAttrDefault("http://projectliberty.org/schemas/core/2002/12");
        this.addNSPrefixAttrDefault("http://projectliberty.org/schemas/authctx/2002/05");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:1.0:protocol");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:1.0:assertion");
    }

    public AuthnRequestEnvelope(Document owner, String providerId, String acsURL) throws DOMException {
        this(owner);
        this.setProviderID(providerId);
        this.setAssertionConsumerServiceURL(acsURL);
    }

    public void setAuthnRequest(AuthnRequest request) {
        LibertyUtils.setChildElement(this, (XMLElement)request, nsURIs, localNames);
    }

    public AuthnRequest getAuthnRequest() {
        return (AuthnRequest)LibertyUtils.getChildElement(this, "http://projectliberty.org/schemas/core/2002/12", "AuthnRequest");
    }

    public void setProviderID(String providerID) {
        LibertyUtils.insertChildElementWithText(this, "http://projectliberty.org/schemas/core/2002/12", "ProviderID", nsURIs, localNames, providerID, true);
    }

    public String getProviderID() {
        return LibertyUtils.collectTextFromChild(this, "http://projectliberty.org/schemas/core/2002/12", "ProviderID");
    }

    public void setProviderName(String providerName) {
        LibertyUtils.insertChildElementWithText(this, "http://projectliberty.org/schemas/core/2002/12", "ProviderName", nsURIs, localNames, providerName, true);
    }

    public String getProviderName() {
        return LibertyUtils.collectTextFromChild(this, "http://projectliberty.org/schemas/core/2002/12", "ProviderName");
    }

    public void setAssertionConsumerServiceURL(String serviceURL) {
        LibertyUtils.insertChildElementWithText(this, "http://projectliberty.org/schemas/core/2002/12", "AssertionConsumerServiceURL", nsURIs, localNames, serviceURL, true);
    }

    public String getAssertionConsumerServiceURL() {
        return LibertyUtils.collectTextFromChild(this, "http://projectliberty.org/schemas/core/2002/12", "AssertionConsumerServiceURL");
    }

    public void setIDPList(IDPList idpList) {
        LibertyUtils.setChildElement(this, idpList, nsURIs, localNames);
    }

    public IDPList getIDPList() {
        return (IDPList)LibertyUtils.getChildElement(this, "http://projectliberty.org/schemas/core/2002/12", "IDPList");
    }

    public void setIsPassive(boolean isPassive) {
        LibertyUtils.insertChildElementWithText(this, "http://projectliberty.org/schemas/core/2002/12", "IsPassive", nsURIs, localNames, "" + isPassive, true);
    }

    public boolean getIsPassive() {
        String value = LibertyUtils.collectTextFromChild(this, "http://projectliberty.org/schemas/core/2002/12", "IsPassive");
        return value == null || !value.equals("false") && !value.equals("0");
    }

    static {
        SAMLInitializer.initialize();
        LibertyInitializer.initialize();
    }
}

