/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.workbench.core.ui.DataMapPanel;
import oracle.dbtools.migration.workbench.core.ui.IntegerDocument;
import oracle.ide.util.ResourceUtils;

public class NewFieldTypePanel
extends JPanel {
    private JComboBox _cmbSourceField;
    private JTextField _txfSourcePrecision;
    private JTextField _txfSourceScale;
    private JComboBox _cmbTargetField;
    private JTextField _txfTargetPrecision;
    private JTextField _txfTargetScale;
    private Collection<DataTypeSpecification> _sourceList;
    private Collection<DataTypeSpecification> _targetList;

    public NewFieldTypePanel(Collection<DataTypeSpecification> collection, Collection<DataTypeSpecification> collection2, DataTypeSpecification dataTypeSpecification, DataTypeSpecification dataTypeSpecification2) {
        super(new GridLayout(1, 2, 10, 5));
        this._sourceList = new HashSet<DataTypeSpecification>(collection);
        this._targetList = new HashSet<DataTypeSpecification>();
        for (DataTypeSpecification dataTypeSpecification3 : collection2) {
            boolean bl = false;
            for (DataTypeSpecification dataTypeSpecification4 : this._targetList) {
                if (!dataTypeSpecification3.getName().equals(dataTypeSpecification4.getName())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this._targetList.add(dataTypeSpecification3);
        }
        this.initGUI();
        this.initializeValues();
        this._cmbSourceField.addItemListener(new ComboListener(this._txfSourcePrecision, this._txfSourceScale));
        this._cmbTargetField.addItemListener(new ComboListener(this._txfTargetPrecision, this._txfTargetScale));
        if (dataTypeSpecification != null) {
            this._cmbSourceField.setSelectedItem(new DataTypeSpecification(dataTypeSpecification.getName()));
            if (dataTypeSpecification.getPrecision() != null) {
                this._txfSourcePrecision.setText(String.valueOf(dataTypeSpecification.getPrecision()));
            }
            if (dataTypeSpecification.getScale() != null) {
                this._txfSourceScale.setText(String.valueOf(dataTypeSpecification.getScale()));
            }
        } else {
            this._cmbSourceField.setSelectedIndex(0);
        }
        if (dataTypeSpecification2 != null) {
            if (!this._targetList.contains(dataTypeSpecification2)) {
                this._cmbTargetField.addItem(dataTypeSpecification2);
            }
            this._cmbTargetField.setSelectedItem(dataTypeSpecification2);
            if (dataTypeSpecification2.getPrecision() != null) {
                this._txfTargetPrecision.setText(String.valueOf(dataTypeSpecification2.getPrecision()));
            }
            if (dataTypeSpecification2.getScale() != null) {
                this._txfTargetScale.setText(String.valueOf(dataTypeSpecification2.getScale()));
            }
        } else {
            this._cmbTargetField.setSelectedIndex(0);
        }
    }

    private void initGUI() {
        this.setPreferredSize(new Dimension(420, 100));
        this.createSourceFieldUI();
        this.createTargetFieldUI();
    }

    private void createSourceFieldUI() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowWeights = new double[]{0.1, 0.1, 0.1};
        gridBagLayout.rowHeights = new int[]{7, 7, 7};
        gridBagLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
        jPanel.setLayout(gridBagLayout);
        jPanel.setPreferredSize(new Dimension(150, 80));
        JLabel jLabel = new JLabel();
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._cmbSourceField = new JComboBox();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._cmbSourceField, (String)(DataMapPanel.SOURCE_DATA_TYPE_AMP + ":"));
        jPanel.add((Component)this._cmbSourceField, new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel2 = new JLabel();
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._txfSourcePrecision = new JTextField();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._txfSourcePrecision, (String)(DataMapPanel.PRECISION + ":"));
        this._txfSourcePrecision.setDocument(new IntegerDocument());
        jPanel.add((Component)this._txfSourcePrecision, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel3 = new JLabel();
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._txfSourceScale = new JTextField();
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._txfSourceScale, (String)(DataMapPanel.SCALE + ":"));
        this._txfSourceScale.setDocument(new IntegerDocument());
        jPanel.add((Component)this._txfSourceScale, new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(jPanel);
    }

    private void createTargetFieldUI() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowWeights = new double[]{0.1, 0.1, 0.1};
        gridBagLayout.rowHeights = new int[]{7, 7, 7};
        gridBagLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
        jPanel.setLayout(gridBagLayout);
        jPanel.setPreferredSize(new Dimension(150, 80));
        JLabel jLabel = new JLabel();
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._cmbTargetField = new JComboBox();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._cmbTargetField, (String)(DataMapPanel.TARGET_DATA_TYPE_AMP + ":"));
        this._cmbTargetField.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof DataTypeSpecification) {
                    return super.getListCellRendererComponent((JList<?>)jList, ((DataTypeSpecification)object).getName(), n, bl, bl2);
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        });
        jPanel.add((Component)this._cmbTargetField, new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel2 = new JLabel();
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._txfTargetPrecision = new JTextField();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._txfTargetPrecision, (String)(DataMapPanel.PRECISION_ORACLE + ":"));
        this._txfTargetPrecision.setDocument(new IntegerDocument());
        jPanel.add((Component)this._txfTargetPrecision, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel3 = new JLabel();
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._txfTargetScale = new JTextField();
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._txfTargetScale, (String)(DataMapPanel.SCALE_ORACLE + ":"));
        this._txfTargetScale.setDocument(new IntegerDocument());
        jPanel.add((Component)this._txfTargetScale, new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(jPanel);
    }

    private void initializeValues() {
        this._cmbSourceField.removeAllItems();
        for (DataTypeSpecification dataTypeSpecification : this._sourceList) {
            this._cmbSourceField.addItem(dataTypeSpecification);
        }
        this._cmbSourceField.setSelectedIndex(-1);
        this._cmbTargetField.removeAllItems();
        for (DataTypeSpecification dataTypeSpecification : this._targetList) {
            this._cmbTargetField.addItem(dataTypeSpecification);
        }
        this._cmbTargetField.setSelectedIndex(-1);
    }

    public DataTypeSpecification getDataTypeSpecification(JComboBox jComboBox, JTextField jTextField, JTextField jTextField2) {
        DataTypeSpecification dataTypeSpecification = (DataTypeSpecification)jComboBox.getSelectedItem();
        if (dataTypeSpecification != null) {
            DataTypeSpecification dataTypeSpecification2 = this.getCopy(dataTypeSpecification);
            Integer n = null;
            if (jTextField.getText().trim().length() > 0) {
                try {
                    n = Integer.valueOf(jTextField.getText().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(numberFormatException.getMessage());
                }
            }
            dataTypeSpecification2.setPrecision(n);
            n = null;
            if (jTextField2.getText().trim().length() > 0) {
                try {
                    n = Integer.valueOf(jTextField2.getText().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(numberFormatException.getMessage());
                }
            }
            dataTypeSpecification2.setScale(n);
            return dataTypeSpecification2;
        }
        return null;
    }

    private DataTypeSpecification getCopy(DataTypeSpecification dataTypeSpecification) {
        DataTypeSpecification dataTypeSpecification2 = new DataTypeSpecification(dataTypeSpecification.getName());
        dataTypeSpecification2.setPrecision(dataTypeSpecification.getPrecision());
        dataTypeSpecification2.setScale(dataTypeSpecification.getScale());
        return dataTypeSpecification2;
    }

    public void setSourceEditable(boolean bl) {
        this._cmbSourceField.setEnabled(bl);
        this._txfSourcePrecision.setEditable(bl);
        this._txfSourceScale.setEditable(bl);
    }

    public DataTypeSpecification getSourceSpecification() {
        return this.getDataTypeSpecification(this._cmbSourceField, this._txfSourcePrecision, this._txfSourceScale);
    }

    public DataTypeSpecification getTargetSpecification() {
        return this.getDataTypeSpecification(this._cmbTargetField, this._txfTargetPrecision, this._txfTargetScale);
    }

    private class ComboListener
    implements ItemListener {
        private JTextField _txfScale;
        private JTextField _txfPrecision;

        public ComboListener(JTextField jTextField, JTextField jTextField2) {
            this._txfScale = jTextField2;
            this._txfPrecision = jTextField;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this._txfScale.setText("");
            this._txfPrecision.setText("");
        }
    }
}

