/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.migration.generate.GenerateException;
import oracle.dbtools.migration.generate.GenerateWorker;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.ui.MigrationSchedulingRule;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.ISchedulingRule;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.internal.ConnectionMutexFactory;
import oracle.dbtools.raptor.backgroundTask.internal.ObjectMutexRule;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;

public class GenerateRunnerTask
extends RaptorTask<Object> {
    private GenerateWorker m_worker;
    private URL m_url;
    private String m_sourceConnName;

    public GenerateRunnerTask(GenerateWorker generateWorker, URL uRL, String string) {
        super(MigrationAddinArb.getString("GENERATERUNNER_TITLE"), true, IRaptorTaskRunMode.MODAL_OPTIONAL);
        this.m_worker = generateWorker;
        this.m_url = uRL;
        this.m_sourceConnName = string;
        this.setMessage(MigrationAddinArb.getString("GENERATERUNNER_INITIAL_MESSAGE"));
        this.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                block6: {
                    Boolean bl = Boolean.FALSE;
                    try {
                        bl = (Boolean)GenerateRunnerTask.this.getResult();
                        if (bl == null || !bl.booleanValue() || GenerateRunnerTask.this.m_url == null) break block6;
                        SqlNode sqlNode = null;
                        try {
                            final SqlNode sqlNode2 = sqlNode = (SqlNode)NodeFactory.findOrCreate(SqlNode.class, (URL)GenerateRunnerTask.this.m_url);
                            if (sqlNode2 != null) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        EditorUtil.openDefaultEditorInFrame((Node)sqlNode2);
                                    }
                                });
                            }
                        }
                        catch (InstantiationException instantiationException) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, instantiationException.getStackTrace()[0].toString(), instantiationException);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, illegalAccessException.getStackTrace()[0].toString(), illegalAccessException);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    protected Object doWork() throws TaskException {
        try {
            if (this.m_worker.runGenerate(MigrationAddin.getMigrationConfig().getSingleSchemaLeastPrivilege())) {
                Boolean bl = Boolean.TRUE;
                return bl;
            }
        }
        catch (GenerateException generateException) {
            throw new TaskException((Throwable)generateException);
        }
        finally {
            MigrationLogUtil.endMigrationLogSession();
        }
        return Boolean.FALSE;
    }

    public boolean cancel() {
        this.m_worker.signalCancel();
        return true;
    }

    public ISchedulingRule getSchedulingRule() {
        ISchedulingRule iSchedulingRule = ConnectionMutexFactory.getRule((String)this.m_sourceConnName);
        ISchedulingRule iSchedulingRule2 = ConnectionMutexFactory.getRule((String)MigrationAddin.getRepositoryConnectionName());
        ObjectMutexRule objectMutexRule = new ObjectMutexRule((Object)"MigrationSession");
        return new MigrationSchedulingRule(iSchedulingRule, iSchedulingRule2, objectMutexRule);
    }
}

