/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.migration.convert.DataTypeSpecification;

public class FilteredTableModel
extends AbstractTableModel
implements TableModelListener {
    private DefaultTableModel _delegateModel;
    private List<Integer> _mappedIndexes = new ArrayList<Integer>();
    private Set<String> _filteredSpecifications;

    public FilteredTableModel(DefaultTableModel defaultTableModel) {
        this._delegateModel = defaultTableModel;
        int n = defaultTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            this._mappedIndexes.add(i);
        }
        this._filteredSpecifications = Collections.EMPTY_SET;
        defaultTableModel.addTableModelListener(this);
    }

    @Override
    public String getColumnName(int n) {
        return this._delegateModel.getColumnName(n);
    }

    public void setFilter(List<DataTypeSpecification> list) {
        this._filteredSpecifications = new HashSet<String>();
        for (DataTypeSpecification dataTypeSpecification : list) {
            this._filteredSpecifications.add(dataTypeSpecification.getName().toLowerCase());
        }
        this.reallocateIndexes();
        this.fireTableDataChanged();
    }

    private void reallocateIndexes() {
        int n = this._delegateModel.getRowCount();
        this._mappedIndexes.clear();
        for (int i = 0; i < n; ++i) {
            DataTypeSpecification dataTypeSpecification = (DataTypeSpecification)this._delegateModel.getValueAt(i, 0);
            if (this._filteredSpecifications.size() != 0 && !this._filteredSpecifications.contains(dataTypeSpecification.getName().toLowerCase())) continue;
            this._mappedIndexes.add(i);
        }
    }

    @Override
    public int getRowCount() {
        if (this._filteredSpecifications == null || this._filteredSpecifications.size() == 0) {
            return this._delegateModel.getRowCount();
        }
        return this._mappedIndexes.size();
    }

    public DefaultTableModel getDelegateModel() {
        return this._delegateModel;
    }

    @Override
    public int getColumnCount() {
        return this._delegateModel.getColumnCount();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this._filteredSpecifications == null || this._filteredSpecifications.size() == 0) {
            return this._delegateModel.getValueAt(n, n2);
        }
        int n3 = this._mappedIndexes.get(n);
        return this._delegateModel.getValueAt(n3, n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this._filteredSpecifications == null || this._filteredSpecifications.size() == 0) {
            this._delegateModel.setValueAt(object, n, n2);
            return;
        }
        int n3 = this._mappedIndexes.get(n);
        this._delegateModel.setValueAt(object, n3, n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this._delegateModel.isCellEditable(n, n2);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.reallocateIndexes();
        this.fireTableChanged(tableModelEvent);
    }

    public void removeRow(int n) {
        if (this._filteredSpecifications == null || this._filteredSpecifications.size() == 0) {
            this._delegateModel.removeRow(n);
            return;
        }
        int n2 = this._mappedIndexes.get(n);
        this._delegateModel.removeRow(n2);
    }

    public int getFilteredRowNumber(int n) {
        return this._mappedIndexes.indexOf(n);
    }
}

