/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.repository.RepositoryManager;
import oracle.dbtools.migration.workbench.core.ui.Messages;
import oracle.dbtools.migration.workbench.core.ui.RepositoryDialog;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.javatools.db.DBException;

public class ClearRepositoryDialog
extends RepositoryDialog {
    private String m_repo = "";

    public ClearRepositoryDialog() {
        super(StringUtils.stripMnemonic((String)MigrationAddinArb.getString("MIGRATION_TRUNCATE_REPOSITORY_TEXT")), MigrationAddinArb.getString("MIGRATION_TRUNCATE_BUTTON"), Messages.getString("ClearRepositoryDialog.1"));
        this.init();
        this.getGui().setVisible(true);
    }

    private void init() {
        this.setComboLabel(StringUtils.stripMnemonic((String)MigrationAddinArb.getString("MIGRATION_TRUNCATE_REPOSITORY_TEXT")));
        this.setHelpId("f1_deleterepository_html");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClearRepositoryDialog.this.getGui().setVisible(false);
                if (ClearRepositoryDialog.this.getRepositoryCombo().getSelectedItem() != null) {
                    ClearRepositoryDialog.this.m_repo = (String)ClearRepositoryDialog.this.getRepositoryCombo().getSelectedItem();
                    String string = MigrationAddin.getMigrationConfig().getDefaultRepository();
                    MigrationAddin.getMigrationConfig().setDefaultRepository(ClearRepositoryDialog.this.m_repo);
                    MigrationAddin.openRepository(ClearRepositoryDialog.this.m_repo);
                    Connection connection = null;
                    try {
                        connection = Connections.getInstance().getConnection(ClearRepositoryDialog.this.m_repo);
                    }
                    catch (DBException dBException) {
                        MigrationLogUtil.logThrowable(dBException.getMessage(), string, (Throwable)dBException);
                        return;
                    }
                    if (connection == null) {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("MIGRATION_REPO_NOT_OPEN"), (String)StringUtils.stripMnemonic((String)MigrationAddinArb.getString("MIGRATION_TRUNCATE_REPOSITORY_TEXT")), (String)"f1_reponotopen_html");
                    } else if (!RepositoryManager.purgeRepository(connection)) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("MIGRATION_TRUNCATE_ERROR"), (String)StringUtils.stripMnemonic((String)MigrationAddinArb.getString("MIGRATION_TRUNCATE_REPOSITORY_TEXT")), (String)"f1_errortruncaterepo_html");
                    }
                    MigrationAddin.getMigrationConfig().setDefaultRepository(string);
                    MigrationAddin.openRepository(string);
                }
                ClearRepositoryDialog.this.getGui().setVisible(false);
                MigrationAddin.openRepository(ClearRepositoryDialog.this.m_repo);
            }
        };
        this.addokActionListener(actionListener);
    }
}

