/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureEventListener;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.CountEventModel;
import oracle.dbtools.migration.workbench.core.ui.FullMigrateProgressRunnable;
import oracle.dbtools.migration.workbench.core.ui.SimpleTablePanel;

class CaptureEventListenerPanel
implements CaptureEventListener {
    private SimpleTablePanel m_eventPanel;
    private FullMigrateProgressRunnable m_runnable;
    private JPanel m_panel;
    private JLabel m_label;

    public CaptureEventListenerPanel(FullMigrateProgressRunnable fullMigrateProgressRunnable) {
        CountEventModel countEventModel = new CountEventModel(new String[]{MigrationAddinArb.getString("OBJECT_TYPE"), MigrationAddinArb.getString("OBJECTS_CAPTURED")});
        this.m_eventPanel = new SimpleTablePanel(200, MigrationAddinArb.getString("FULLMIGRATION_TOOLTIP_CAPTURE"), countEventModel);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(10);
        this.m_panel = new JPanel();
        this.m_panel.setLayout(borderLayout);
        this.m_panel.add((Component)this.m_eventPanel, "Center");
        this.m_label = new JLabel();
        this.m_panel.add((Component)this.m_label, "South");
        this.m_runnable = fullMigrateProgressRunnable;
    }

    public JPanel getPanel() {
        return this.m_panel;
    }

    public String getPanelName() {
        return MigrationAddinArb.getString("FULLMIGRATION_TAB_CAPTURE");
    }

    @Override
    public void raiseEvent(CaptureEvent captureEvent) {
        Object object = "";
        this.m_label.setText("");
        switch (captureEvent.getEventId()) {
            case 1: {
                object = MigrationAddinArb.getString("CAPTURING") + " " + captureEvent.getEventSource();
                break;
            }
            case 2: {
                object = captureEvent.getEventSource() + " " + MigrationAddinArb.getString("CAPTURED");
                break;
            }
            case 3: {
                object = MigrationAddinArb.getString("STORING") + " " + captureEvent.getEventSource();
                break;
            }
            case 4: {
                object = MigrationAddinArb.getString("STORED") + " " + captureEvent.getEventSource();
                break;
            }
            case 5: {
                return;
            }
            case 6: {
                object = MigrationAddinArb.getString("START_CAPTURE");
                break;
            }
            case 7: {
                object = MigrationAddinArb.getString("END_CAPTURE");
                break;
            }
            case 8: {
                object = captureEvent.getEventSourceType();
                this.m_label.setText((String)object);
            }
        }
        this.m_runnable.updateProgress(captureEvent.getEventId(), captureEvent, object);
        this.m_eventPanel.updateProgress(captureEvent.toEventString());
    }
}

