/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.repository;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.convert.DataTypeMappingRule;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.convert.SupportedDataTypesMap;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.CapturedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.MigrationRepositoryDatabases;
import oracle.dbtools.migration.workbench.core.navigator.net.MigrationURLFormatHelper;
import oracle.dbtools.migration.workbench.core.repository.Messages;
import oracle.dbtools.migration.workbench.core.repository.UpdateTypePanel;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;

public class UpdateColumnTypeAction
extends AbstractMenuAction {
    private MigrationRepositoryDatabases m_instance;

    public void launch() {
        DBObject dBObject = this.getDBObject();
        if (dBObject.getElement() instanceof ChildObjectElement) {
            DBObjectId dBObjectId = MigrationURLFormatHelper.getColumnId(dBObject.getURL());
            try {
                final MdColumn mdColumn = MdColumn.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), dBObjectId);
                SupportedDataTypesMap supportedDataTypesMap = this.getSupportedDataTypeMap();
                DataTypeSpecification[] dataTypeSpecificationArray = null;
                dataTypeSpecificationArray = this.m_instance instanceof ConvertedDatabases ? this.getAllTargetDataType(supportedDataTypesMap) : supportedDataTypesMap.getSourceDataTypes();
                final UpdateTypePanel updateTypePanel = new UpdateTypePanel(dataTypeSpecificationArray);
                updateTypePanel.setCurrentColumnType(mdColumn.getColumnType(), mdColumn.getPrecision(), mdColumn.getScale());
                int n = 14;
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (actionEvent.getActionCommand() == "apply") {
                            String string = updateTypePanel.getTypeName();
                            Integer n = updateTypePanel.getPrecision();
                            Integer n2 = updateTypePanel.getScale();
                            mdColumn.setColumnType(string);
                            mdColumn.setPrecision(n);
                            mdColumn.setScale(n2);
                            try {
                                mdColumn.save(MigrationAddin.getPersistenceManager());
                            }
                            catch (PersistenceException persistenceException) {
                                UpdateColumnTypeAction.this.warn(persistenceException);
                            }
                            ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                        }
                    }
                };
                HelpSystem.getHelpSystem().registerTopic((JComponent)updateTypePanel, "f1_updatecolumntype_html");
                String string = Messages.getString("UpdateColumnTypeAction.1");
                UIUtils.showPanelAsDialog((JPanel)updateTypePanel, (String)string, (ActionListener)actionListener, (int)n, (boolean)true);
            }
            catch (PersistenceException persistenceException) {
                MigrationLogUtil.logThrowable(persistenceException.getMessage(), "", (Throwable)persistenceException);
                this.warn(persistenceException);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                MigrationLogUtil.logThrowable(noSuchObjectException.getMessage(), "", (Throwable)noSuchObjectException);
                this.warn(noSuchObjectException);
            }
        }
    }

    private DataTypeSpecification[] getAllTargetDataType(SupportedDataTypesMap supportedDataTypesMap) {
        ArrayList<DataTypeSpecification> arrayList = new ArrayList<DataTypeSpecification>();
        if (supportedDataTypesMap == null) {
            return new DataTypeSpecification[0];
        }
        for (DataTypeSpecification dataTypeSpecification : supportedDataTypesMap.getSourceDataTypes()) {
            DataTypeMappingRule[] dataTypeMappingRuleArray = supportedDataTypesMap.getRulesForDataType(dataTypeSpecification);
            for (int i = 0; i < dataTypeMappingRuleArray.length; ++i) {
                arrayList.add(dataTypeMappingRuleArray[i].getTargetDataType());
            }
        }
        return arrayList.toArray(new DataTypeSpecification[0]);
    }

    private SupportedDataTypesMap getSupportedDataTypeMap() throws PersistenceException, NoSuchObjectException {
        SupportedDataTypesMap supportedDataTypesMap = null;
        try {
            Element element = this.getDBObject().getElement();
            DBObjectId dBObjectId = MigrationURLFormatHelper.getSchemaId(((ChildObjectElement)element).getURL());
            MdSchema mdSchema = MdSchema.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), dBObjectId);
            MdCatalog mdCatalog = MdCatalog.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), mdSchema.getCatalogId());
            MdConnection mdConnection = MdConnection.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), mdCatalog.getConnectionId());
            String string = mdConnection.getProperty("PLUGIN_ID");
            if (string == null) {
                return null;
            }
            MigrationPlugin migrationPlugin = MigrationAddin.findPlugin(string);
            if (migrationPlugin == null) {
                return null;
            }
            supportedDataTypesMap = migrationPlugin.getSupportedDataTypesMap();
        }
        catch (MigrationPluginException migrationPluginException) {
            MigrationLogUtil.logThrowable(migrationPluginException.getMessage(), "", (Throwable)migrationPluginException);
            return null;
        }
        return supportedDataTypesMap;
    }

    public void setArgs(String string) {
        this.m_instance = string.equals("CAPTURED") ? CapturedDatabases.getInstance() : ConvertedDatabases.getInstance();
    }
}

