/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.repository;

import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.DerivativesIterator;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdDerivative;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.convert.Converter;
import oracle.dbtools.migration.convert.ConverterWorker;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.persistence.MigrDatatypeTransformMap;
import oracle.dbtools.migration.translation.api.ITranslator;
import oracle.dbtools.migration.workbench.core.Messages;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationFilterUtil;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.net.MigrationURLFormatHelper;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CapturedNode;
import oracle.dbtools.migration.workbench.core.ui.ConvertObjectRunnerTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;

public class ReconvertMDNodeAction
extends AbstractMenuAction {
    private boolean reconvert;

    public void launch() {
        if (this.getDBObject() == null || !(this.getDBObject().getElement() instanceof CapturedNode)) {
            return;
        }
        try {
            DBObject dBObject = this.getDBObject();
            MdConnection mdConnection = MigrationUtils.getConnforDBObject(dBObject);
            MigrationPlugin migrationPlugin = this.getPlugin(mdConnection);
            Converter converter = migrationPlugin.getConverter();
            ITranslator iTranslator = converter.getPlaformTranslator();
            if (iTranslator == null) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)Messages.getString("TranslatorNotAvailable"), (String)Messages.getString("TranslatorNotAvailable"), null);
                return;
            }
            Context context = this.getContext();
            MigrationObjectFilterList migrationObjectFilterList = MigrationFilterUtil.generateFilters(context);
            PersistenceUtility persistenceUtility = PersistenceUtility.getInstance(MigrationAddin.getPersistenceManager());
            MigrationURLFormatHelper migrationURLFormatHelper = new MigrationURLFormatHelper();
            PersistableObject persistableObject = persistenceUtility.loadPersistableObject(MigrationURLFormatHelper.getObjectId(dBObject.getURL()), MigrationUtils.mapSDToSDMWType(dBObject.getObjectType()));
            String string = this.getConvertedID("" + mdConnection.getKey().getId());
            if (string == null) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)Messages.getString("ConvertedModelNotAvailable"), (String)Messages.getString("ConvertedModelNotAvailable"), null);
                return;
            }
            MdConnection mdConnection2 = MdConnection.getExistingInstance(new DBObjectId(Long.parseLong(string)));
            ConverterWorker converterWorker = new ConverterWorker(MigrationAddin.getPersistenceManager(), mdConnection.getKey(), converter, this.getMapId(MigrationAddin.getPersistenceManager(), mdConnection.getProjectId()), migrationObjectFilterList, mdConnection2);
            ConvertObjectRunnerTask convertObjectRunnerTask = new ConvertObjectRunnerTask(converterWorker, migrationPlugin.getPlatformMask(), mdConnection.getName(), persistableObject);
            RaptorTaskManager.getInstance().addTask((RaptorTask)convertObjectRunnerTask);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "MigrationLog.UNKNOWN_ERROR";
            }
            MigrationLogUtil.logThrowable(string, Messages.getString("ConvertInitiator.5"), (Throwable)exception);
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private String getConvertedID(String string) {
        DerivativesIterator derivativesIterator = new DerivativesIterator(MigrationAddin.getPersistenceManager(), null, "  derivative_reason IS NULL AND src_id = " + string);
        if (derivativesIterator.hasNext()) {
            MdDerivative mdDerivative = (MdDerivative)derivativesIterator.next();
            DBObjectId dBObjectId = mdDerivative.getDerivedId();
            return dBObjectId.toString();
        }
        return null;
    }

    private MigrationPlugin getPlugin(MdConnection mdConnection) {
        try {
            return MigrationUtils.getPluginForConnection(mdConnection);
        }
        catch (MigrationPluginException migrationPluginException) {
            migrationPluginException.printStackTrace();
            return null;
        }
    }

    private DBObjectId getMapId(PersistenceManager persistenceManager, DBObjectId dBObjectId) {
        MigrDatatypeTransformMap migrDatatypeTransformMap = null;
        DBObjectId dBObjectId2 = null;
        try {
            migrDatatypeTransformMap = ConvertUtils.getMapForProjectId(persistenceManager, dBObjectId);
            dBObjectId2 = migrDatatypeTransformMap.getKey();
        }
        catch (PersistenceException persistenceException) {
            persistenceException.printStackTrace();
        }
        return dBObjectId2;
    }

    public void setArgs(String string) {
        if (string != null && "RECONVERT".equals(string)) {
            this.reconvert = true;
        }
    }
}

