/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.preferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.preferences.UserDefinedMasks;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class DataMovePreferencesPane
extends DefaultTraversablePanel {
    private JTextField m_timestampMask;
    private JTextField m_dateMask;
    private JTextField m_commitNumber;
    private JTextField m_paralellStreams;
    private JTextField m_eocTextField;
    private JTextField m_eorTextField;
    private JComboBox m_EmptyStringIsSpace;
    private UserDefinedMasks m_userDefinedMasks;
    public static final String TITLE = MigrationAddinArb.getString("DATAMOVE_PREF_TITLE");
    private static final long serialVersionUID = -5271014805893212390L;

    public DataMovePreferencesPane() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(null, MigrationAddinArb.getString("DATAMOVE_BOTH"), 0, 0, null, null));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        this.add(jPanel, gridBagConstraints);
        this.m_EmptyStringIsSpace = new JComboBox();
        this.m_EmptyStringIsSpace.setModel(new DefaultComboBoxModel<String>(new String[]{"' '", "NULL"}));
        this.m_EmptyStringIsSpace.setName(StringUtils.stripMnemonic((String)MigrationAddinArb.getString("DATAMOVE_NULL_STRING")));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 1;
        jPanel.add((Component)this.m_EmptyStringIsSpace, gridBagConstraints2);
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_EmptyStringIsSpace, (String)MigrationAddinArb.getString("DATAMOVE_NULL_STRING"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridx = 2;
        jPanel.add((Component)jLabel, gridBagConstraints3);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new TitledBorder(null, MigrationAddinArb.getString("DMSP_ONLINE"), 0, 0, null, null));
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.weighty = 1.0;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.gridx = 1;
        this.add(jPanel2, gridBagConstraints4);
        this.m_paralellStreams = new JTextField();
        this.m_paralellStreams.setPreferredSize(new Dimension(40, 20));
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.insets = new Insets(5, 5, 5, 5);
        jPanel2.add((Component)this.m_paralellStreams, gridBagConstraints5);
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.m_paralellStreams, (String)MigrationAddinArb.getString("DMSP_NUM_PARALLEL"));
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.gridy = 0;
        gridBagConstraints6.gridx = 1;
        jPanel2.add((Component)jLabel2, gridBagConstraints6);
        this.m_commitNumber = new JTextField();
        this.m_commitNumber.setPreferredSize(new Dimension(40, 20));
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints7.anchor = 18;
        gridBagConstraints7.gridy = 1;
        gridBagConstraints7.gridx = 0;
        jPanel2.add((Component)this.m_commitNumber, gridBagConstraints7);
        JLabel jLabel3 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.m_commitNumber, (String)MigrationAddinArb.getString("DSMP_NUM_ROWS_COMMIT"));
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.weighty = 1.0;
        gridBagConstraints8.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints8.anchor = 18;
        gridBagConstraints8.gridy = 1;
        gridBagConstraints8.gridx = 1;
        jPanel2.add((Component)jLabel3, gridBagConstraints8);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new TitledBorder(null, MigrationAddinArb.getString("DSMP_OFFLINE"), 0, 0, null, null));
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints9.weighty = 8.0;
        gridBagConstraints9.fill = 1;
        gridBagConstraints9.gridy = 2;
        gridBagConstraints9.gridx = 1;
        this.add(jPanel3, gridBagConstraints9);
        this.m_eocTextField = new JTextField();
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.fill = 2;
        gridBagConstraints10.anchor = 18;
        gridBagConstraints10.insets = new Insets(5, 5, 5, 135);
        gridBagConstraints10.weightx = 1.0;
        gridBagConstraints10.weighty = 0.0;
        gridBagConstraints10.gridy = 1;
        gridBagConstraints10.gridx = 1;
        jPanel3.add((Component)this.m_eocTextField, gridBagConstraints10);
        JLabel jLabel4 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this.m_eocTextField, (String)MigrationAddinArb.getString("OFFLINE_DM_OPTIONS_EOC"));
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.anchor = 13;
        gridBagConstraints11.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints11.gridy = 1;
        gridBagConstraints11.gridx = 0;
        jPanel3.add((Component)jLabel4, gridBagConstraints11);
        this.m_eorTextField = new JTextField();
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.fill = 2;
        gridBagConstraints12.anchor = 18;
        gridBagConstraints12.weighty = 0.0;
        gridBagConstraints12.insets = new Insets(5, 5, 0, 135);
        gridBagConstraints12.weightx = 1.0;
        gridBagConstraints12.gridy = 2;
        gridBagConstraints12.gridx = 1;
        jPanel3.add((Component)this.m_eorTextField, gridBagConstraints12);
        JLabel jLabel5 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel5, (Component)this.m_eorTextField, (String)MigrationAddinArb.getString("OFFLINE_DM_OPTIONS_EOR"));
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints13.anchor = 12;
        gridBagConstraints13.gridy = 2;
        gridBagConstraints13.gridx = 0;
        jPanel3.add((Component)jLabel5, gridBagConstraints13);
        JLabel jLabel6 = new JLabel();
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.anchor = 13;
        gridBagConstraints14.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints14.gridy = 4;
        gridBagConstraints14.gridx = 0;
        jPanel3.add((Component)jLabel6, gridBagConstraints14);
        this.m_dateMask = new JTextField();
        ResourceUtils.resLabel((JLabel)jLabel6, (Component)this.m_dateMask, (String)MigrationAddinArb.getString("OFFLINE_DM_DATE_MASK"));
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints15.fill = 2;
        gridBagConstraints15.gridy = 4;
        gridBagConstraints15.gridx = 1;
        jPanel3.add((Component)this.m_dateMask, gridBagConstraints15);
        JLabel jLabel7 = new JLabel();
        GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
        gridBagConstraints16.anchor = 12;
        gridBagConstraints16.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints16.gridy = 5;
        gridBagConstraints16.gridx = 0;
        jPanel3.add((Component)jLabel7, gridBagConstraints16);
        this.m_timestampMask = new JTextField();
        ResourceUtils.resLabel((JLabel)jLabel7, (Component)this.m_timestampMask, (String)MigrationAddinArb.getString("OFFLINE_DM_TIMESTAMP_MASK"));
        GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
        gridBagConstraints17.anchor = 18;
        gridBagConstraints17.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints17.fill = 2;
        gridBagConstraints17.gridy = 5;
        gridBagConstraints17.gridx = 1;
        jPanel3.add((Component)this.m_timestampMask, gridBagConstraints17);
        this.m_userDefinedMasks = new UserDefinedMasks();
        GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
        gridBagConstraints18.anchor = 18;
        gridBagConstraints18.weighty = 10.0;
        gridBagConstraints18.weightx = 1.0;
        gridBagConstraints18.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints18.fill = 1;
        gridBagConstraints18.gridy = 6;
        gridBagConstraints18.gridx = 0;
        gridBagConstraints18.gridwidth = 2;
        jPanel3.add((Component)((Object)this.m_userDefinedMasks), gridBagConstraints18);
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_migprefdatamove_html");
    }

    public void onEntry(TraversableContext traversableContext) {
        MigrationConfig migrationConfig = DataMovePreferencesPane.getConfigFromContext(traversableContext);
        this.m_paralellStreams.setText(String.valueOf(migrationConfig.getNumDataMoveThreads()));
        this.m_commitNumber.setText(String.valueOf(migrationConfig.getDataMoveCommitInterval()));
        this.m_eocTextField.setText(migrationConfig.getEndColumnDelimiter());
        this.m_eorTextField.setText(migrationConfig.getEndRowDelimiter());
        this.m_dateMask.setText(migrationConfig.getDateOfflineDateMask());
        this.m_timestampMask.setText(migrationConfig.getTimeStampOfflineDateMask());
        if (migrationConfig.getEmptyStringIsSpace()) {
            this.m_EmptyStringIsSpace.setSelectedIndex(0);
        } else {
            this.m_EmptyStringIsSpace.setSelectedIndex(1);
        }
        this.m_userDefinedMasks.onEntry(traversableContext);
    }

    public void onExit(TraversableContext traversableContext) {
        MigrationConfig migrationConfig = DataMovePreferencesPane.getConfigFromContext(traversableContext);
        migrationConfig.setNumDataMoveThreads(Integer.parseInt(this.m_paralellStreams.getText()));
        migrationConfig.setDataMoveCommitInterval(Integer.parseInt(this.m_commitNumber.getText()));
        migrationConfig.setEndColumnDelimiter(this.m_eocTextField.getText());
        migrationConfig.setEndRowDelimiter(this.m_eorTextField.getText());
        migrationConfig.setDateOfflineDateMask(this.m_dateMask.getText());
        migrationConfig.setTimestampOfflineDateMask(this.m_timestampMask.getText());
        if (this.m_EmptyStringIsSpace.getSelectedIndex() != 0) {
            migrationConfig.setEmptyStringIsSpace(false);
        } else {
            migrationConfig.setEmptyStringIsSpace(true);
        }
        try {
            this.m_userDefinedMasks.onExit(traversableContext);
        }
        catch (TraversalException traversalException) {
            // empty catch block
        }
    }

    private static MigrationConfig getConfigFromContext(TraversableContext traversableContext) {
        return MigrationConfig.getInstance(traversableContext.getPropertyStorage());
    }
}

