/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator.nodes;

import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.navigator.AbstractMigrationNavigatorManager;
import oracle.dbtools.migration.workbench.core.navigator.CapturedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.AbstractLoadChildrenTask;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CatalogFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.ConvertedModelsFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.DefaultContainerCustomNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectTreeNode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.WrappedException;
import oracle.dbtools.raptor.navigator.db.model.DBCatalogInstance;
import oracle.dbtools.raptor.navigator.db.model.DBCatalogsInstance;
import oracle.dbtools.raptor.navigator.db.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.db.model.DBItemInstance;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.model.Element;
import oracle.ide.net.URLFactory;

public class CapturedObjectsFolderNode
extends DefaultContainerCustomNode {
    protected static final Logger LOGGER = Logger.getLogger(CapturedObjectsFolderNode.class.getName());
    private DBObjectId _parentId;
    private MigrationConnectionNode _parent;

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public CapturedObjectsFolderNode(DBObjectId dBObjectId, MigrationConnectionNode migrationConnectionNode) {
        this._parentId = dBObjectId;
        this._parent = migrationConnectionNode;
        String string = this._parentId.toString();
        this.setURL(URLFactory.newURL((String)"sqldev.migration", (String)(MigrationAddin.getRepositoryConnectionName() + "/" + string + "/" + CapturedObjectsFolderNode.class.getSimpleName())));
    }

    public String getShortLabel() {
        return MigrationAddinArb.getString("CAPTURED_OBJECTS_ROOT_LABEL");
    }

    public Icon getIcon() {
        return CapturedConnectionNode.getCaptureIcon();
    }

    @Override
    protected void queueBackgroundLoadChildrenTask() {
        AbstractLoadChildrenTask abstractLoadChildrenTask = new AbstractLoadChildrenTask((Element)this){

            protected List<Element> doWork() throws TaskException {
                ArrayList<Element> arrayList;
                block7: {
                    arrayList = new ArrayList<Element>();
                    MigrationConnectionNode migrationConnectionNode = CapturedObjectsFolderNode.this._parent;
                    try {
                        String string;
                        ObjectFactory objectFactory = AbstractMigrationNavigatorManager.getRegistry().getFactory(migrationConnectionNode.getShortLabel(), (Connection)migrationConnectionNode.getConnection());
                        if (objectFactory == null || (string = ConvertedModelsFolderNode.getURLProtocol((Element)migrationConnectionNode)) == null || !objectFactory.isSupportsCatalog()) break block7;
                        DBCatalogsInstance dBCatalogsInstance = objectFactory.getCatalogsInstance();
                        try {
                            MigrationProjectTreeNode.fillInInheritedInitialProperties((DBItemInstance)dBCatalogsInstance, migrationConnectionNode);
                            for (DBChildInstance dBChildInstance : dBCatalogsInstance.listChildren()) {
                                this.checkStatus("create catalogs");
                                DBCatalogInstance dBCatalogInstance = (DBCatalogInstance)dBChildInstance;
                                URL uRL = DBURLFormatHelper.getURL((String)string, (String)migrationConnectionNode.getQualifiedConnectionName(), (String)((String)dBCatalogInstance.getProperty("CATALOG")), null, null);
                                CatalogFolderNode catalogFolderNode = new CatalogFolderNode(uRL, dBCatalogInstance, migrationConnectionNode.getMdConnection(), migrationConnectionNode.getConnType());
                                arrayList.add((Element)catalogFolderNode);
                            }
                        }
                        catch (SQLException sQLException) {
                            ExceptionHandler.handleException((Throwable)sQLException);
                        }
                    }
                    catch (IOException iOException) {
                        Throwable throwable = iOException;
                        if (iOException instanceof WrappedException) {
                            throwable = iOException.getCause();
                        }
                        throw new TaskException(throwable);
                    }
                    catch (AbortException abortException) {
                        throw new TaskException((Throwable)abortException);
                    }
                }
                return arrayList;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)abstractLoadChildrenTask);
    }

    @Override
    public String getObjectName() {
        return "MD_CATALOGS";
    }

    @Override
    public String getObjectType() {
        return "CAPTURED_OBJECTS_FOLDER";
    }

    @Override
    public HashMap<String, Object> getDict() {
        if (null == this._dict) {
            super.getDict();
            this._dict.put("IDCONNECTION", this._parentId.toString());
            this._dict.put("CONNECTION_OBJID", this._parentId);
            this._dict.put("IDCAPCONNECTION", this._parentId.toString());
            this._dict.put("IDCONCONNECTION", this.getConvertedID(this._parentId.toString()));
        }
        return this._dict;
    }
}

