/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.actions;

import java.awt.Component;
import java.awt.Window;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MigrLogIterator;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.persistence.Migrlog;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.actions.Messages;
import oracle.dbtools.migration.workbench.core.logging.ClickableLogInfo;
import oracle.dbtools.migration.workbench.core.logging.LogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogHandler;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.ExceptionDialog;

public class ShowLogAction
extends AbstractMenuAction {
    public void launch() {
        final Element[] elementArray = this.getContext().getSelection();
        DatabaseQueryTask<Object> databaseQueryTask = new DatabaseQueryTask<Object>("Load log", IRaptorTaskRunMode.IDE_STATUSBAR, false, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doWork() throws TaskException {
                for (Element element : elementArray) {
                    this.setMessage(Messages.getString("MigrationLog.Loading1"));
                    if (!(element instanceof MigrationConnectionNode)) continue;
                    String string = ((MigrationConnectionNode)element).getObjectId();
                    try {
                        DBObjectId dBObjectId = new DBObjectId(Long.valueOf(string));
                        MigrationLogUtil.startMigrationLogSession(dBObjectId);
                        String string2 = Messages.getString("MigrationLog.Loading2") + ((MigrationConnectionNode)element).getLongLabel();
                        this.setMessage(string2);
                        ShowLogAction.this.loadProjectLogs(dBObjectId);
                    }
                    finally {
                        MigrationLogUtil.endMigrationLogSession();
                    }
                }
                return null;
            }

            public String getConnectionName() {
                return MigrationAddin.getRepositoryConnectionName();
            }

            public String getQuery() {
                return "";
            }
        };
        databaseQueryTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter((RaptorTask)databaseQueryTask){
            final /* synthetic */ RaptorTask val$task;
            {
                this.val$task = raptorTask;
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                try {
                    this.val$task.getResult();
                }
                catch (InterruptedException interruptedException) {
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)interruptedException);
                }
                catch (ExecutionException executionException) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)executionException.getCause());
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception.getCause(), (String)RaptorTaskUtils.getErrorMessage((Throwable)exception));
                }
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                this.taskFailed(raptorTaskEvent);
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
    }

    private void loadProjectLogs(DBObjectId dBObjectId) {
        HashMap<DBObjectId, LogRecord> hashMap = new HashMap<DBObjectId, LogRecord>();
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        PersistableObject persistableObject = null;
        try {
            MigrLogIterator<Migrlog> migrLogIterator = PersistenceUtility.getInstance(persistenceManager).getLogsForProjectId(dBObjectId);
            while (migrLogIterator.hasNext()) {
                LogRecord logRecord;
                Migrlog migrlog = (Migrlog)migrLogIterator.next();
                if (migrlog.getParentLogId() == null) {
                    if (persistableObject != null) {
                        MigrationLogHandler.getInstance().publish((LogRecord)hashMap.get(persistableObject.getKey()));
                        persistableObject = null;
                        hashMap.clear();
                    }
                    persistableObject = migrlog;
                    logRecord = this.getLogRecord(migrlog);
                    hashMap.put(migrlog.getKey(), logRecord);
                    continue;
                }
                logRecord = this.getLogRecord(migrlog);
                LogRecord logRecord2 = (LogRecord)hashMap.get(migrlog.getParentLogId());
                if (logRecord2 == null) continue;
                List<LogInfo> list = MigrationLogUtil.searchParameterByType(logRecord2.getParameters(), LogInfo.class);
                list.get(0).addChild(logRecord);
                hashMap.put(migrlog.getKey(), logRecord);
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (PersistenceException persistenceException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (persistableObject != null) {
            MigrationLogHandler.getInstance().publish((LogRecord)hashMap.get(persistableObject.getKey()));
            persistableObject = null;
            hashMap.clear();
        }
    }

    private LogRecord getLogRecord(Migrlog migrlog) {
        LogRecord logRecord = new LogRecord(Level.parse(String.valueOf(migrlog.getSeverity())), migrlog.getLogtext());
        logRecord.setLoggerName("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
        logRecord.setMillis(migrlog.getLogDate().getTime());
        LogInfo logInfo = null;
        if (migrlog.getRefObjectId() != null) {
            String string = migrlog.getRefObjectType();
            PersistenceUtility persistenceUtility = PersistenceUtility.getInstance(MigrationAddin.getPersistenceManager());
            PersistableObject persistableObject = null;
            try {
                persistableObject = persistenceUtility.loadPersistableObject(migrlog.getRefObjectId(), string);
            }
            catch (PersistenceException persistenceException) {
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
            logInfo = new ClickableLogInfo(persistableObject, migrlog.getPhase());
        }
        if (logInfo == null) {
            logInfo = new LogInfo(migrlog.getPhase());
        }
        logRecord.setParameters(new Object[]{logInfo});
        return logRecord;
    }

    public void setArgs(String string) {
    }
}

