/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.convert.Converter;
import oracle.dbtools.migration.convert.ConverterWorker;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.convert.SupportedDataTypesMap;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.persistence.MigrDatatypeTransformMap;
import oracle.dbtools.migration.workbench.core.Messages;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationFilterUtil;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.ui.ConvertDailogTaskUI;
import oracle.dbtools.migration.workbench.core.ui.ConvertRunnerTask;
import oracle.dbtools.migration.workbench.core.ui.DataMapPanel;
import oracle.dbtools.migration.workbench.core.ui.IdentifierMappingPanel;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskUI;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskViewer;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.MessageDialog;

public class ConvertInitiator
extends AbstractMenuAction {
    public void launch() {
        try {
            Object object;
            Context context = this.getContext();
            DBObject dBObject = this.getDBObject();
            if (null == dBObject) {
                object = context.getSelection();
                assert (object != null && ((Element[])object).length > 0);
                dBObject = new DBObject(object[0]);
            }
            object = MigrationFilterUtil.generateFilters(context);
            MdConnection mdConnection = MigrationUtils.getConnforDBObject(dBObject);
            String string = "";
            if (mdConnection != null) {
                string = MigrationUtils.getPluginIdForConnection(mdConnection);
            }
            if (string.equals("")) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("MSG_CANNOT_CONVERT"), (String)MigrationAddinArb.getString("TITLE_CANNOT_CONVERT"), (String)"help_migr_no_plugin_saved");
                return;
            }
            MigrationPlugin migrationPlugin = MigrationAddin.findPlugin(string);
            if (migrationPlugin == null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("MSG_PLUGIN_NO_LONGER_AVAILABLE"), (String)MigrationAddinArb.getString("TITLE_CANNOT_CONVERT"), (String)"help_migr_plugin_unavailable");
                return;
            }
            Converter converter = migrationPlugin.getConverter();
            SupportedDataTypesMap supportedDataTypesMap = migrationPlugin.getSupportedDataTypesMap();
            DBObjectId dBObjectId = this.getMapId(MigrationAddin.getPersistenceManager(), mdConnection.getKey(), mdConnection.getProjectId(), supportedDataTypesMap);
            if (dBObjectId == null) {
                return;
            }
            ConverterWorker converterWorker = new ConverterWorker(MigrationAddin.getPersistenceManager(), mdConnection.getKey(), converter, dBObjectId, (MigrationObjectFilterList)object);
            ConvertRunnerTask convertRunnerTask = new ConvertRunnerTask(converterWorker, migrationPlugin.getPlatformMask(), mdConnection.getName());
            final ConvertDailogTaskUI convertDailogTaskUI = new ConvertDailogTaskUI(convertRunnerTask.getDescriptor());
            converterWorker.addEventListener(convertDailogTaskUI);
            this.attachPostProcessCallback(convertRunnerTask, dBObject);
            RaptorTaskManager.getInstance().addTask((RaptorTask)convertRunnerTask, Collections.singletonList(new ITaskViewer(){

                public void addTaskUI(ITaskUI iTaskUI) {
                }

                public ITaskUI getTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
                    return convertDailogTaskUI;
                }

                public ITaskUI createTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
                    return this.getTaskUI(raptorTaskDescriptor);
                }

                public void taskCancelRequested(RaptorTaskDescriptor raptorTaskDescriptor) {
                }

                public void taskPauseRequested(RaptorTaskDescriptor raptorTaskDescriptor) {
                }

                public void removeTaskUI(ITaskUI iTaskUI) {
                }
            }));
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "MigrationLog.UNKNOWN_ERROR";
            }
            MigrationLogUtil.logThrowable(string, Messages.getString("ConvertInitiator.5"), (Throwable)exception);
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    protected DBObjectId getMapId(PersistenceManager persistenceManager, DBObjectId dBObjectId, DBObjectId dBObjectId2, SupportedDataTypesMap supportedDataTypesMap) throws PersistenceException {
        MigrDatatypeTransformMap migrDatatypeTransformMap = ConvertUtils.getMapForProjectId(persistenceManager, dBObjectId2);
        if (migrDatatypeTransformMap == null) {
            return this.getDataTypeMapFromUser(persistenceManager, dBObjectId, supportedDataTypesMap);
        }
        return migrDatatypeTransformMap.getKey();
    }

    public void setArgs(String string) {
    }

    protected DBObjectId getDataTypeMapFromUser(PersistenceManager persistenceManager, DBObjectId dBObjectId, SupportedDataTypesMap supportedDataTypesMap) throws PersistenceException {
        PersistenceUtility persistenceUtility = PersistenceUtility.getInstance(persistenceManager);
        String[] stringArray = persistenceUtility.getAllDataTypesForConnection(dBObjectId);
        DataTypeSpecification[] dataTypeSpecificationArray = new DataTypeSpecification[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            dataTypeSpecificationArray[i] = new DataTypeSpecification(stringArray[i]);
        }
        final DataMapPanel dataMapPanel = new DataMapPanel(supportedDataTypesMap, dataTypeSpecificationArray);
        String string = MigrationAddinArb.getString("DATA_IDENTIFIER_TITLE");
        final IdentifierMappingPanel identifierMappingPanel = null;
        String string2 = MigrationAddinArb.getString("DATA_MAPPING_TAB");
        String string3 = MigrationAddinArb.getString("IDENTIFIER_MAPPING_TAB");
        JPanel[] jPanelArray = new JPanel[]{dataMapPanel, identifierMappingPanel};
        String[] stringArray2 = new String[]{string2, string3};
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() == "apply") {
                    DBObject dBObject = ConvertInitiator.this.getDBObject();
                    DBObjectId dBObjectId = null;
                    Object object = actionEvent.getSource();
                    if (object instanceof JEWTDialog) {
                        dBObjectId = dataMapPanel.save(dBObject);
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                identifierMappingPanel.save();
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                    if (dBObjectId != null) {
                        ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                    }
                }
            }
        };
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DBObject dBObject = ConvertInitiator.this.getDBObject();
                Object object = changeEvent.getSource();
                if (object instanceof JTabbedPane) {
                    int n = ((JTabbedPane)object).getSelectedIndex();
                    if (n == 0) {
                        if (identifierMappingPanel.isInitialized()) {
                            identifierMappingPanel.save();
                        }
                    } else if (n == 1) {
                        dataMapPanel.save(dBObject);
                        if (!identifierMappingPanel.isInitialized()) {
                            identifierMappingPanel.init();
                        }
                    }
                }
            }
        };
        JEWTDialog jEWTDialog = UIUtils.createTabbedPanelDialog((JPanel[])jPanelArray, (String[])stringArray2, (String)string, (ActionListener)actionListener, null, (ChangeListener)changeListener);
        jEWTDialog.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
                    identifierMappingPanel.cleanUp();
                }
            }
        });
        jEWTDialog.runDialog();
        return dataMapPanel.getSavedMapId();
    }
}

