/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MigrDatatypeTransformRule
extends PersistableObject {
    public static final String TABLE_NAME = "MIGR_DATATYPE_TRANSFORM_RULE";
    public static final String COLNAME_MAP_ID_FK = "MAP_ID_FK";
    public static final String COLNAME_SOURCE_DATA_TYPE_NAME = "SOURCE_DATA_TYPE_NAME";
    public static final String COLNAME_SOURCE_PRECISION = "SOURCE_PRECISION";
    public static final String COLNAME_SOURCE_SCALE = "SOURCE_SCALE";
    public static final String COLNAME_TARGET_DATA_TYPE_NAME = "TARGET_DATA_TYPE_NAME";
    public static final String COLNAME_TARGET_PRECISION = "TARGET_PRECISION";
    public static final String COLNAME_TARGET_SCALE = "TARGET_SCALE";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";

    public MigrDatatypeTransformRule(DBObjectId dBObjectId, String string, String string2) {
        this.setMapId(dBObjectId);
        this.setSourceDataTypeName(string);
        this.setTargetDataTypeName(string2);
    }

    public static MigrDatatypeTransformRule getExistingInstance(DBObjectId dBObjectId) {
        MigrDatatypeTransformRule migrDatatypeTransformRule = new MigrDatatypeTransformRule();
        migrDatatypeTransformRule.setKey(dBObjectId);
        return migrDatatypeTransformRule;
    }

    private MigrDatatypeTransformRule() {
    }

    public static MigrDatatypeTransformRule retrieveExistingInstance(PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException {
        MigrDatatypeTransformRule migrDatatypeTransformRule = MigrDatatypeTransformRule.getExistingInstance(dBObjectId);
        migrDatatypeTransformRule.retrieve(persistenceManager);
        return migrDatatypeTransformRule;
    }

    protected void setMapId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_MAP_ID_FK, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    protected void setSourceDataTypeName(String string) {
        Field field = new Field(COLNAME_SOURCE_DATA_TYPE_NAME, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setSourcePrecision(Integer n) {
        Field field = new Field(COLNAME_SOURCE_PRECISION, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setSourceScale(Integer n) {
        Field field = new Field(COLNAME_SOURCE_SCALE, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    protected void setTargetDataTypeName(String string) {
        Field field = new Field(COLNAME_TARGET_DATA_TYPE_NAME, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setTargetPrecision(Integer n) {
        Field field = new Field(COLNAME_TARGET_PRECISION, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setTargetScale(Integer n) {
        Field field = new Field(COLNAME_TARGET_SCALE, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setSecurityGroupId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setCreatedOn(Date date) {
        Field field = new Field(COLNAME_CREATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setCreatedBy(String string) {
        Field field = new Field(COLNAME_CREATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setLastUpdatedOn(Date date) {
        Field field = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setLastUpdatedBy(String string) {
        Field field = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public DBObjectId getMapId() {
        Field field = this.getField(COLNAME_MAP_ID_FK);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public String getSourceDataTypeName() {
        Field field = this.getField(COLNAME_SOURCE_DATA_TYPE_NAME);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Integer getSourcePrecision() {
        Field field = this.getField(COLNAME_SOURCE_PRECISION);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public Integer getSourceScale() {
        Field field = this.getField(COLNAME_SOURCE_SCALE);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public String getTargetDataTypeName() {
        Field field = this.getField(COLNAME_TARGET_DATA_TYPE_NAME);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Integer getTargetPrecision() {
        Field field = this.getField(COLNAME_TARGET_PRECISION);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public Integer getTargetScale() {
        Field field = this.getField(COLNAME_TARGET_SCALE);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public DBObjectId getSecurityGroupId() {
        Field field = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field field = this.getField(COLNAME_CREATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getCreatedBy() {
        Field field = this.getField(COLNAME_CREATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Date getLastUpdatedOn() {
        Field field = this.getField(COLNAME_LAST_UPDATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getLastUpdatedBy() {
        Field field = this.getField(COLNAME_LAST_UPDATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public void retrieve(PersistenceManager persistenceManager) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet closeableResultSet = this.issueRetrieveQuery(persistenceManager);
        ResultSet resultSet = closeableResultSet.getResultSet();
        try {
            this.setMapId(new DBObjectId(resultSet.getLong(COLNAME_MAP_ID_FK)));
            this.setSourceDataTypeName(resultSet.getString(COLNAME_SOURCE_DATA_TYPE_NAME));
            Object object = resultSet.getInt(COLNAME_SOURCE_PRECISION);
            if (resultSet.wasNull()) {
                this.setSourcePrecision(null);
            } else {
                this.setSourcePrecision((Integer)object);
            }
            object = resultSet.getInt(COLNAME_SOURCE_SCALE);
            if (resultSet.wasNull()) {
                this.setSourceScale(null);
            } else {
                this.setSourceScale((Integer)object);
            }
            this.setTargetDataTypeName(resultSet.getString(COLNAME_TARGET_DATA_TYPE_NAME));
            object = resultSet.getInt(COLNAME_TARGET_PRECISION);
            if (resultSet.wasNull()) {
                this.setTargetPrecision(null);
            } else {
                this.setTargetPrecision((Integer)object);
            }
            object = resultSet.getInt(COLNAME_TARGET_SCALE);
            if (resultSet.wasNull()) {
                this.setTargetScale(null);
            } else {
                this.setTargetScale((Integer)object);
            }
            object = new DBObjectId(resultSet.getLong(COLNAME_SECURITY_GROUP_ID));
            if (resultSet.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)object);
            }
            object = resultSet.getDate(COLNAME_CREATED_ON);
            if (resultSet.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_CREATED_BY);
            if (resultSet.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)object);
            }
            object = resultSet.getDate(COLNAME_LAST_UPDATED_ON);
            if (resultSet.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_LAST_UPDATED_BY);
            if (resultSet.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)object);
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            closeableResultSet.close();
        }
        this.retrieveAdditionalProperties(persistenceManager);
        this.clearUpdatedFields();
    }

    @Override
    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

