/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.generate;

import java.io.File;
import java.io.PrintStream;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdProject;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.command_line.CMDLineError;
import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.MigrationCmd;
import oracle.dbtools.migration.command_line.MigrationCmdRegistry;
import oracle.dbtools.migration.command_line.MigrationDetails;
import oracle.dbtools.migration.convert.ListConvertedModelsCmd;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.generate.GenerateWorker;
import oracle.dbtools.migration.generate.SimpleGenerationOutputStream;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationFilterUtil;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;

public class GenerateCmd
extends MigrationCmd {
    public static final String CMDNAME = "generate";
    private static final String DEFAULT_TEMPLATE_NAME = "10g";

    public GenerateCmd(MigrationDetails migrationDetails, CMDOut cMDOut, boolean bl) {
        super(CMDNAME, migrationDetails, cMDOut, bl);
    }

    @Override
    protected void executeImpl() throws CMDLineError {
        this.verifyRepository();
        ListConvertedModelsCmd listConvertedModelsCmd = null;
        Long l = null;
        MdConnection mdConnection = null;
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        DBObjectId dBObjectId = null;
        DBObjectId dBObjectId2 = null;
        String string = "";
        MigrationPlugin migrationPlugin = null;
        GenerateWorker generateWorker = null;
        String string2 = null;
        SimpleGenerationOutputStream simpleGenerationOutputStream = null;
        String string3 = DEFAULT_TEMPLATE_NAME;
        boolean bl = false;
        String string4 = Ide.getEnvironOptions().getEncoding();
        File file = null;
        try {
            Object object;
            String string5;
            if (persistenceManager == null) {
                string5 = MigrationAddin.getDefaultMigrationRepository();
                object = Connections.getInstance().getConnection(string5);
                MigrationAddin.openRepository(string5);
                persistenceManager = MigrationAddin.getPersistenceManager();
            }
            if (this.getMigrationDetails().getCurrentConvertedModel() == null) {
                int n = -1;
                listConvertedModelsCmd = (ListConvertedModelsCmd)MigrationCmdRegistry.getMigrationCmd("lsconverted", this.getMigrationDetails(), this.getCmdout(), true);
                listConvertedModelsCmd.execute();
                object = this.getMigrationDetails().get("model");
                if (listConvertedModelsCmd.hasSingleConvertedModel() || object != null && "latest".equalsIgnoreCase(((String)object).trim())) {
                    l = listConvertedModelsCmd.getLatestConvertedModel();
                } else if (object != null) {
                    n = Integer.parseInt((String)object);
                    l = listConvertedModelsCmd.getModelIdForIndex(n);
                } else if (!listConvertedModelsCmd.hasSingleConvertedModel() && object == null) {
                    listConvertedModelsCmd.printModelList();
                    n = this.getCmdout().promptForModelSelection();
                    l = listConvertedModelsCmd.getModelIdForIndex(n);
                } else {
                    throw new IllegalStateException("There are no valid converted models in the repository");
                }
                if (l != null) {
                    this.getMigrationDetails().setCurrentConvertedModel(Long.toString(l));
                } else {
                    throw new IllegalStateException("Unable to locate converted model corresponding to id: " + n);
                }
            }
            if ((mdConnection = MdConnection.retrieveExistingInstance(persistenceManager, dBObjectId = new DBObjectId(Long.parseLong(string5 = this.getMigrationDetails().getCurrentConvertedModel())))) != null) {
                string = MigrationUtils.getPluginIdForConnection(mdConnection);
                dBObjectId2 = mdConnection.getProjectId();
                if (dBObjectId2 == null) {
                    throw new IllegalStateException("converted connection project id not found");
                }
                migrationPlugin = MigrationAddin.findPlugin(string);
                string2 = this.getMigrationDetails().get("output");
                object = null;
                if (string2 != null && string2.trim().length() > 0) {
                    object = new File(string2);
                    Object object2 = ((File)object).getCanonicalPath();
                    object2 = (String)object2 + File.separator + "gen";
                    file = new File((String)object2);
                    boolean bl2 = true;
                    if (!file.exists()) {
                        bl2 = file.mkdirs();
                    }
                    if (!bl2) {
                        throw new IllegalStateException("Unable to create necessary output directory");
                    }
                    file = File.createTempFile("generated-", ".sql", file);
                    simpleGenerationOutputStream = string4 == null ? new SimpleGenerationOutputStream(new PrintStream(file)) : new SimpleGenerationOutputStream(new PrintStream(file, string4));
                } else {
                    throw new IllegalArgumentException("output directory is invalid or not found");
                }
                generateWorker = new GenerateWorker(persistenceManager, dBObjectId, simpleGenerationOutputStream, string3, MigrationFilterUtil.getFullFilter(), false);
                generateWorker.setProjectName(MdProject.retrieveExistingInstance(persistenceManager, dBObjectId2).getProjectName());
                generateWorker.setOutputDir(((File)object).getCanonicalPath());
                bl = generateWorker.runGenerate(false);
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        if (!bl) {
            throw new CMDLineError(CMDNAME, "Script generation failed", null);
        }
        this.getCmdout().printResult("Script created:" + file.getAbsolutePath());
        this.getMigrationDetails().setGenerationScript(file.getAbsolutePath());
    }
}

