/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.offline.streams;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import oracle.dbtools.migration.datamove.offline.streams.OfflineDMSAbstract;

public abstract class OfflineOracleDMSAbstract
extends OfflineDMSAbstract {
    private static final String ORACLE = "oracle";
    private String BASEFILE_NAME = "oracle_{0}.{1}";

    public OfflineOracleDMSAbstract(String string, String string2) {
        super(string, string2);
    }

    @Override
    public void endSchema() {
        super.endSchema();
        this.println(this.preWriter, this.scriptGenerator.getConstraintOff(), false);
        this.println(this.postWriter, this.scriptGenerator.getConstraintOn(), false);
        this.flushnclose(this.truncWriter, null);
        this.flushnclose(this.preWriter, this.postWriter);
    }

    @Override
    public void endTable() {
        this.flushnclose(this.tableWriter, null);
    }

    @Override
    public String getBaseFileName() {
        return this.BASEFILE_NAME;
    }

    @Override
    public abstract String getExtension();

    @Override
    public void startSchema(String string, String string2) {
        super.startSchema(string, string2);
        if (this.truncatable) {
            this.truncWriter = this.getPrintWriter("trunc.sql", this.getSchemaDir() + File.separator + this.getDir());
        }
        this.preWriter = this.getPrintWriter("pre_load.sql", this.getSchemaDir() + File.separator + this.getDir());
        this.println(this.preWriter, this.scriptGenerator.getSQLErrorStatement(), false);
        this.println(this.preWriter, this.scriptGenerator.alterTableClob(string, this.m_descriptor, this.m_plugin), false);
        this.println(this.preWriter, this.scriptGenerator.getDisableTriggersForSchema(), false);
        this.println(this.preWriter, this.scriptGenerator.generateDirectoryObject(this.getSchemaDir(), this.m_descriptor.getTargetSchema().getName()), false);
        this.postWriter = this.getPrintWriter("post_load.sql", this.getSchemaDir() + File.separator + this.getDir());
        this.println(this.postWriter, this.scriptGenerator.getSQLErrorStatement(), false);
        this.println(this.postWriter, this.scriptGenerator.callBlobToClob(string, this.m_descriptor, this.m_plugin), false);
        this.println(this.postWriter, this.scriptGenerator.getEnableTriggersForSchema(), false);
        this.println(this.postWriter, this.scriptGenerator.getEnableIdentityForSchema(), false);
        this.println(this.postWriter, this.scriptGenerator.dropDirectoryObject(this.m_descriptor.getTargetSchema().getName()), false);
    }

    @Override
    public void startTable(String string) {
        String string2 = this.getSchemaDir() + File.separator + this.getDir();
        OfflineOracleDMSAbstract.setWriteDir(string2);
        String string3 = string + this.getFileName() + "." + this.getExtension();
        String string4 = string2 + File.separator + string3;
        try {
            this.tableWriter = new PrintWriter(new File(string4));
            this.println(this.tableWriter, this.scriptGenerator.getTableCommand(this.m_descriptor, this.getExtension(), string, this.m_plugin), false);
            this.println(this.schemaWriterWindows, this.scriptGenerator.getStreamBody(this.schemadir, string, true), false);
            this.println(this.schemaWriterNix, this.scriptGenerator.getStreamBody(this.schemadir, string, false), false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        if (this.truncatable) {
            this.println(this.truncWriter, this.scriptGenerator.getTruncStatement(string), false);
        }
    }

    protected abstract String getDir();
}

