/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.offline;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.datamove.online.Messages;
import oracle.dbtools.migration.datamove.online.TriggerHandler;

public class OfflineTriggerHandler
extends TriggerHandler {
    private static final String GET_TRIGGERS_QUERY = "SELECT TRIGGER_NAME, SCHEMA_NAME FROM MGV_ALL_TABLE_TRIGGERS WHERE CONNECTION_ID = ? AND CATALOG_NAME = ? AND SCHEMA_NAME = ?";

    public OfflineTriggerHandler(DBObjectId dBObjectId, PersistenceManager persistenceManager) {
        super(dBObjectId, persistenceManager);
    }

    public void disableTriggers(String string, String string2, boolean bl) {
        this.disableTriggers(null, string, string2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disableTriggers(Connection connection, String string, String string2, boolean bl) {
        if (connection == null) {
            throw new IllegalArgumentException(Messages.getString("TriggerHandler.1"));
        }
        if (connection != null) {
            throw new IllegalArgumentException(Messages.getString("TriggerHandler.2"));
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.m_persistenceManager.getPreparedStatement(GET_TRIGGERS_QUERY);
            preparedStatement.setLong(1, this.m_connectionId.getId());
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string2);
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            s_log.warning(sQLException.getLocalizedMessage());
            CloseableResultSet.close(null, resultSet);
            return;
        }
        try {
            try {
                if (resultSet != null) {
                    while (resultSet.next()) {
                        TriggerHandler.TriggerInformation triggerInformation = new TriggerHandler.TriggerInformation(resultSet);
                        boolean bl2 = false;
                        if (connection != null) {
                            bl2 = this.issueTriggerStmt(connection, triggerInformation.getDisableStatment(bl));
                        }
                        if (!bl2) continue;
                        this.m_disabledTriggers.add(triggerInformation);
                    }
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                s_log.warning(sQLException.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(null, resultSet);
            throw throwable;
        }
        CloseableResultSet.close(null, resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<TriggerHandler.TriggerInformation> getTriggers(String string, String string2) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.m_persistenceManager.getPreparedStatement(GET_TRIGGERS_QUERY);
            preparedStatement.setLong(1, this.m_connectionId.getId());
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string2);
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            s_log.warning(sQLException.getLocalizedMessage());
            HashSet<TriggerHandler.TriggerInformation> hashSet = null;
            CloseableResultSet.close(null, resultSet);
            return hashSet;
        }
        try {
            try {
                if (resultSet != null) {
                    while (resultSet.next()) {
                        TriggerHandler.TriggerInformation triggerInformation = new TriggerHandler.TriggerInformation(resultSet);
                        this.m_disabledTriggers.add(triggerInformation);
                    }
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                s_log.warning(sQLException.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(null, resultSet);
            throw throwable;
        }
        CloseableResultSet.close(null, resultSet);
        return this.m_disabledTriggers;
    }
}

