/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.offline;

import java.io.File;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.command_line.CMDLineError;
import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.MigrationCmd;
import oracle.dbtools.migration.command_line.MigrationCmdRegistry;
import oracle.dbtools.migration.command_line.MigrationDetails;
import oracle.dbtools.migration.convert.ListConvertedModelsCmd;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.datamove.offline.OfflineDataMoveWorker;
import oracle.dbtools.migration.datamove.offline.streams.OfflineDataMoveStream;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.raptor.utils.Connections;

public class OfflineDataMoveCmd
extends MigrationCmd {
    public static final String CMDNAME = "datamove";

    public OfflineDataMoveCmd(MigrationDetails migrationDetails, CMDOut cMDOut, boolean bl) {
        super(CMDNAME, migrationDetails, cMDOut, bl);
    }

    @Override
    protected void executeImpl() throws CMDLineError {
        this.verifyRepository();
        ListConvertedModelsCmd listConvertedModelsCmd = null;
        Long l = null;
        MdConnection mdConnection = null;
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        DBObjectId dBObjectId = null;
        DBObjectId dBObjectId2 = null;
        String string = "";
        MigrationPlugin migrationPlugin = null;
        OfflineDataMoveWorker offlineDataMoveWorker = null;
        String string2 = null;
        Object object = null;
        try {
            Object object2;
            String string3;
            if (persistenceManager == null) {
                string3 = MigrationAddin.getDefaultMigrationRepository();
                object2 = Connections.getInstance().getConnection(string3);
                MigrationAddin.openRepository(string3);
                persistenceManager = MigrationAddin.getPersistenceManager();
            }
            if (this.getMigrationDetails().getCurrentConvertedModel() == null) {
                int n = -1;
                listConvertedModelsCmd = (ListConvertedModelsCmd)MigrationCmdRegistry.getMigrationCmd("lsconverted", this.getMigrationDetails(), this.getCmdout(), true);
                listConvertedModelsCmd.execute();
                object2 = this.getMigrationDetails().get("model");
                if (listConvertedModelsCmd.hasSingleConvertedModel() || object2 != null && "latest".equalsIgnoreCase(((String)object2).trim())) {
                    l = listConvertedModelsCmd.getLatestConvertedModel();
                } else if (object2 != null) {
                    n = Integer.parseInt((String)object2);
                    l = listConvertedModelsCmd.getModelIdForIndex(n);
                } else if (!listConvertedModelsCmd.hasSingleConvertedModel() && object2 == null) {
                    listConvertedModelsCmd.printModelList();
                    n = this.getCmdout().promptForModelSelection();
                    l = listConvertedModelsCmd.getModelIdForIndex(n);
                } else {
                    throw new IllegalStateException("There are no valid converted models in the repository");
                }
                if (l != null) {
                    this.getMigrationDetails().setCurrentConvertedModel(Long.toString(l));
                } else {
                    throw new IllegalStateException("Unable to locate converted model corresponding to id: " + n);
                }
            }
            if ((mdConnection = MdConnection.retrieveExistingInstance(persistenceManager, dBObjectId = new DBObjectId(Long.parseLong(string3 = this.getMigrationDetails().getCurrentConvertedModel())))) != null) {
                Object object3;
                string = MigrationUtils.getPluginIdForConnection(mdConnection);
                dBObjectId2 = mdConnection.getProjectId();
                migrationPlugin = MigrationAddin.findPlugin(string);
                string2 = this.getMigrationDetails().get("output");
                object2 = null;
                if (string2 != null && string2.trim().length() > 0) {
                    object2 = new File(string2);
                    object = ((File)object2).getCanonicalPath();
                    object = (String)object + File.separator + CMDNAME;
                    object3 = new File((String)object);
                    boolean bl = true;
                    if (!((File)object3).exists()) {
                        bl = ((File)object3).mkdirs();
                    }
                    if (!bl) {
                        throw new IllegalStateException("Unable to create necessary output directory");
                    }
                } else {
                    throw new IllegalArgumentException("output directory is invalid or not found");
                }
                object3 = migrationPlugin.getPlatformName();
                if (((String)object3).equals("sql server")) {
                    object3 = "Sybase";
                }
                Object object4 = OfflineDataMoveStream.getTimeStamp();
                object4 = ((String)object4).replaceFirst(":", "h");
                object4 = ((String)object4).replaceFirst(":", "m");
                object4 = (String)object4 + "s";
                offlineDataMoveWorker = new OfflineDataMoveWorker(persistenceManager, mdConnection, (String)object);
                offlineDataMoveWorker.doWork();
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }
}

