/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.core;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.migration.core.Cancelable;
import oracle.dbtools.migration.core.Messages;

public abstract class MigrationContext
implements Cancelable {
    private boolean m_shouldCancel = false;
    private static final String FIELD_REGEX = "\\$\\{.+?\\}";
    protected Map<String, Object> m_vars = Collections.synchronizedMap(new HashMap());

    public void setContextVariable(String string, Object object) {
        this.m_vars.put(string.toUpperCase(), object);
    }

    public void resetContextVariable(String string) {
        String string2 = string.toUpperCase();
        if (this.m_vars.containsKey(string2)) {
            this.m_vars.remove(string2);
        }
    }

    public Object getContextVariable(String string) {
        String string2 = string.toUpperCase();
        if (this.m_vars.containsKey(string2)) {
            return this.m_vars.get(string2);
        }
        return null;
    }

    public String applyToSQLString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Pattern pattern = Pattern.compile(FIELD_REGEX);
            Matcher matcher = pattern.matcher(string);
            Object object = "";
            while (matcher.find()) {
                Object object2;
                String string2 = matcher.group();
                if ((string2 = string2.subSequence(2, string2.length() - 1).toString().toUpperCase()).indexOf(46) != -1) {
                    String string3 = string2.substring(0, string2.indexOf(46));
                    String string4 = string2.substring(string2.indexOf(46) + 1);
                    object2 = this.getContextVariable(string3);
                    if (!(object2 instanceof PersistableObject)) {
                        throw new IllegalStateException(MessageFormat.format(Messages.getString("MigrationContext.2"), string2));
                    }
                    PersistableObject persistableObject = (PersistableObject)object2;
                    object = persistableObject.getProperty(string4);
                    if (object == null) {
                        throw new IllegalStateException(MessageFormat.format(Messages.getString("MigrationContext.3"), string2));
                    }
                } else {
                    object2 = this.getContextVariable(string2);
                    if (object2 == null) {
                        throw new IllegalStateException(MessageFormat.format(Messages.getString("MigrationContext.4"), string2));
                    }
                    object = object2.toString();
                }
                int n = 0;
                while ((n = ((String)object).indexOf(36, n)) >= 0) {
                    object = ((String)object).substring(0, n) + "\\" + ((String)object).substring(n);
                    n += 2;
                }
                matcher.appendReplacement(stringBuffer, (String)object);
            }
            matcher.appendTail(stringBuffer);
        }
        catch (Exception exception) {
            throw new IllegalStateException(MessageFormat.format(Messages.getString("MigrationContext.4"), exception.getLocalizedMessage()));
        }
        return stringBuffer.toString();
    }

    @Override
    public void signalCancel() {
        this.m_shouldCancel = true;
    }

    public boolean shouldCancel() {
        return this.m_shouldCancel;
    }
}

