/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.convert;

import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.DBObjectHierarchy;
import oracle.dbtools.metadata.persistence.MdMigrDependency;
import oracle.dbtools.metadata.persistence.MdMigrWeakdep;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.core.util.MultiLevelLogManager;
import oracle.dbtools.migration.parser.analysis.action.TSQLAnalysisAction;
import oracle.dbtools.migration.translation.api.ITranslationLogging;
import oracle.dbtools.migration.translation.api.TranslationLimitation;
import oracle.dbtools.migration.translation.api.TranslationProgress;
import oracle.dbtools.migration.translation.api.components.TranslationParameter;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;

public class TranslationLogging
implements ITranslationLogging {
    private PersistenceManager m_pm = null;
    private MultiLevelLogManager m_translationLogManager;
    private static ResourceBundle s_bundle = ResourceBundle.getBundle("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");

    public TranslationLogging(PersistenceManager persistenceManager, MultiLevelLogManager multiLevelLogManager) {
        this.m_pm = persistenceManager;
        this.m_translationLogManager = multiLevelLogManager;
    }

    public void saveSourceDependency(TranslationDBObjectReference translationDBObjectReference, TranslationDBObjectReference translationDBObjectReference2) {
        if (translationDBObjectReference2.getOMWBObj() == null) {
            this.saveWeakDependency(translationDBObjectReference, translationDBObjectReference2);
        } else {
            this.saveDependency(translationDBObjectReference, translationDBObjectReference2);
        }
    }

    public void saveTargetDependency(TranslationDBObjectReference translationDBObjectReference, TranslationDBObjectReference translationDBObjectReference2) {
        if (translationDBObjectReference2.getOMWBObj() == null) {
            this.saveWeakDependency(translationDBObjectReference, translationDBObjectReference2);
        } else {
            this.saveDependency(translationDBObjectReference, translationDBObjectReference2);
        }
    }

    public void saveSourceParameters(TranslationDBObjectReference translationDBObjectReference, ArrayList<TranslationParameter> arrayList) {
    }

    public void saveTargetParameters(TranslationDBObjectReference translationDBObjectReference, ArrayList<TranslationParameter> arrayList) {
    }

    public void saveSourceStatementUsage(TranslationDBObjectReference translationDBObjectReference, TSQLAnalysisAction tSQLAnalysisAction) {
    }

    public void saveTargetStatementUsage(TranslationDBObjectReference translationDBObjectReference, TSQLAnalysisAction tSQLAnalysisAction) {
    }

    public void reportLimitation(TranslationLimitation translationLimitation) {
        try {
            String string = s_bundle.getString(((PersistableObject)translationLimitation.getSourceDBObject().getOMWBObj()).getObjectType());
            this.m_translationLogManager.logMessage((PersistableObject)translationLimitation.getSourceDBObject().getOMWBObj(), Level.WARNING, "Convert.TRANSLATION_LIMITATION", new Object[]{translationLimitation.getLabel(), string, translationLimitation.getSourceDBObject().getFullName(), translationLimitation.getStartLine(), translationLimitation.getStartColumn()});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reportTranslationProgress(TranslationProgress translationProgress) {
    }

    private void saveDependency(TranslationDBObjectReference translationDBObjectReference, TranslationDBObjectReference translationDBObjectReference2) {
        if (translationDBObjectReference == null || translationDBObjectReference2 == null || translationDBObjectReference.getOMWBObj() == null || translationDBObjectReference2.getOMWBObj() == null) {
            return;
        }
        PersistableObject persistableObject = (PersistableObject)translationDBObjectReference.getOMWBObj();
        PersistableObject persistableObject2 = (PersistableObject)translationDBObjectReference2.getOMWBObj();
        DBObjectHierarchy dBObjectHierarchy = new DBObjectHierarchy(persistableObject, this.m_pm);
        MdMigrDependency mdMigrDependency = new MdMigrDependency(dBObjectHierarchy.getConnection().getKey(), persistableObject.getKey(), persistableObject2.getKey(), persistableObject.getObjectType(), persistableObject2.getObjectType());
        try {
            mdMigrDependency.save(this.m_pm);
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
        }
    }

    private void saveWeakDependency(TranslationDBObjectReference translationDBObjectReference, TranslationDBObjectReference translationDBObjectReference2) {
        if (translationDBObjectReference == null || translationDBObjectReference2 == null) {
            return;
        }
        PersistableObject persistableObject = (PersistableObject)translationDBObjectReference.getOMWBObj();
        if (persistableObject == null) {
            return;
        }
        DBObjectHierarchy dBObjectHierarchy = new DBObjectHierarchy(persistableObject, this.m_pm);
        MdMigrWeakdep mdMigrWeakdep = null;
        mdMigrWeakdep = new MdMigrWeakdep(dBObjectHierarchy.getConnection().getKey(), dBObjectHierarchy.getSchema().getKey(), persistableObject.getKey(), translationDBObjectReference2.getFullName(), persistableObject.getObjectType(), translationDBObjectReference2.getType().getSimpleTypeName());
        try {
            mdMigrWeakdep.save(this.m_pm);
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
        }
    }
}

