/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.convert;

import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.convert.Messages;

public class DataTypeMappingRule {
    private DataTypeSpecification m_sourceDataType;
    private DataTypeSpecification m_targetDataType;

    public DataTypeMappingRule(DataTypeSpecification dataTypeSpecification, DataTypeSpecification dataTypeSpecification2) {
        this.setSourceDataType(dataTypeSpecification);
        this.setTargetDataType(dataTypeSpecification2);
    }

    public DataTypeSpecification getSourceDataType() {
        return this.m_sourceDataType;
    }

    private void setSourceDataType(DataTypeSpecification dataTypeSpecification) {
        if (dataTypeSpecification == null) {
            throw new IllegalArgumentException(Messages.getString("DataTypeMappingRule.0"));
        }
        this.m_sourceDataType = dataTypeSpecification;
    }

    public DataTypeSpecification getTargetDataType() {
        return this.m_targetDataType;
    }

    private void setTargetDataType(DataTypeSpecification dataTypeSpecification) {
        if (dataTypeSpecification == null) {
            throw new IllegalArgumentException(Messages.getString("DataTypeMappingRule.1"));
        }
        this.m_targetDataType = dataTypeSpecification;
    }

    public String toString() {
        return this.m_sourceDataType.toString() + " => " + this.m_targetDataType.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getRuleMatchScore(DataTypeSpecification dataTypeSpecification) {
        DataTypeSpecification dataTypeSpecification2 = this.getSourceDataType();
        int n = 0;
        if (!dataTypeSpecification2.getName().equals(dataTypeSpecification.getName())) return 0;
        ++n;
        if (dataTypeSpecification2.hasPrecision()) {
            if (!dataTypeSpecification2.getPrecision().equals(dataTypeSpecification.getPrecision())) return 0;
            ++n;
            if (dataTypeSpecification2.hasScale()) {
                if (!dataTypeSpecification2.getScale().equals(dataTypeSpecification.getScale())) return 0;
                ++n;
                return n;
            } else {
                if (dataTypeSpecification.hasScale()) return n;
                ++n;
            }
            return n;
        } else {
            if (dataTypeSpecification.hasPrecision()) return n;
            ++n;
            ++n;
        }
        return n;
    }
}

