/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.command_line;

import java.io.IOException;
import oracle.dbtools.migration.command_line.CMDLineError;
import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.CMDUtil;
import oracle.dbtools.migration.command_line.ConnectionDetails;
import oracle.dbtools.migration.command_line.MigrationCmd;
import oracle.dbtools.migration.command_line.MigrationDetails;
import oracle.dbtools.migration.command_line.MkConnCmd;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.repository.RepositoryManager;
import oracle.ide.config.Preferences;

public class InitCmd
extends MigrationCmd {
    InitDetails m_initDetails = null;
    public static final String CMDNAME = "init";

    public InitCmd(MigrationDetails migrationDetails, CMDOut cMDOut, boolean bl) {
        super(CMDNAME, migrationDetails, cMDOut, bl);
        this.m_initDetails = new InitDetails(migrationDetails);
    }

    protected void setMigrationDetails(MigrationDetails migrationDetails) {
        this.m_initDetails = new InitDetails(migrationDetails);
    }

    @Override
    protected void executeImpl() throws CMDLineError {
        String[] stringArray = this.m_initDetails.getConnectionList();
        if (stringArray != null) {
            for (String string : stringArray) {
                MkConnCmd mkConnCmd = new MkConnCmd(string, this.getCmdout(), this.isSilent());
                mkConnCmd.execute();
            }
        }
        if (this.m_initDetails.hasMigRepoConn()) {
            this.associateMigrationRepo(this.m_initDetails.getMigRepoConnName());
        } else {
            this.associateMigrationRepo(this.getDefaultMigrationRepoConnName());
        }
    }

    private String getDefaultMigrationRepoConnName() {
        return "migrepo";
    }

    private String getDefaultMigrationRepoConnPassword() {
        return "migrepo";
    }

    private void associateMigrationRepo(String string) throws CMDLineError {
        String string2 = CMDUtil.getQualifiedName(string);
        RepositoryManager.findOrCreateRepositoryTables(string2, false);
        MigrationAddin.getMigrationConfig().setDefaultRepository(string2);
        try {
            Preferences.getPreferences().save();
        }
        catch (IOException iOException) {
            throw new CMDLineError(CMDNAME, "Problem saving preferences", iOException);
        }
    }

    private String createConnDetails(String string, String string2, String string3) {
        ConnectionDetails connectionDetails = new ConnectionDetails(string);
        connectionDetails.setUsername(string2);
        connectionDetails.setPassword(string3);
        return connectionDetails.getUrlFormat();
    }

    private class InitDetails {
        MigrationDetails m_migrationDetails = null;
        String migrepoconn = null;
        String superconn = null;
        String sourceconn = null;
        String targetconn = null;
        String migrepoconnName = null;
        ConnectionDetails migrepoconnDetails = null;
        ConnectionDetails superconnDetails = null;
        ConnectionDetails sourceconnDetails = null;
        ConnectionDetails targetconnDetails = null;
        String[] connList = null;

        InitDetails(MigrationDetails migrationDetails) {
            String[] stringArray;
            this.m_migrationDetails = migrationDetails;
            String string = this.m_migrationDetails.get("connDetails");
            if (string != null) {
                stringArray = this.connList = string.split(",");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String string2 = stringArray[i];
                    if (string2.toLowerCase().startsWith("super")) {
                        this.superconn = string2;
                        this.superconnDetails = new ConnectionDetails(this.superconn);
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("mig")) {
                        this.migrepoconn = string2;
                        this.migrepoconnDetails = new ConnectionDetails(this.migrepoconn);
                        this.migrepoconnName = this.migrepoconnDetails.getConnName();
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("source")) {
                        this.sourceconn = string2;
                        this.sourceconnDetails = new ConnectionDetails(this.sourceconn);
                        continue;
                    }
                    if (!string2.toLowerCase().startsWith("target")) continue;
                    this.targetconn = string2;
                    this.targetconnDetails = new ConnectionDetails(this.targetconn);
                }
            }
            if ((stringArray = this.m_migrationDetails.get("conn")) != null) {
                this.migrepoconnName = stringArray;
            }
        }

        public String getMigRepoConnName() {
            return this.migrepoconnName;
        }

        public String getSuperConnDetails() {
            return this.superconn;
        }

        public boolean hasMigRepoConn() {
            return this.migrepoconnName != null;
        }

        public String getSuperConnName() {
            if (this.hasSuperConn()) {
                return this.superconnDetails.getConnName();
            }
            return null;
        }

        public boolean hasSuperConn() {
            return this.superconn != null;
        }

        public String[] getConnectionList() {
            return this.connList;
        }
    }
}

