/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.command_line;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.migration.command_line.CMDLineError;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;

public class CMDUtil {
    public static String getRepositoryConnectionName() throws CMDLineError {
        String string = MigrationAddin.getDefaultMigrationRepository();
        if (string == null) {
            throw new CMDLineError(null, "No default repository connection found. The default repository connection needs to be associated in the SQL Developer (GUI) first", null);
        }
        if (!MigrationAddin.isRepositoryOpen()) {
            MigrationAddin.openRepository(string);
        }
        return string;
    }

    public static Connection getConnectionFromSimpleName(String string) throws CMDLineError {
        String string2 = CMDUtil.getQualifiedName(string);
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(string2);
        }
        catch (DBException dBException) {
            throw new CMDLineError(null, dBException.getLocalizedMessage(), null);
        }
        if (connection == null) {
            throw new CMDLineError(null, "The connection:" + string + " , does not exist", null);
        }
        try {
            if (connection.isClosed()) {
                throw new CMDLineError(null, "The Connection is closed", null);
            }
        }
        catch (SQLException sQLException) {
            connection = null;
        }
        return connection;
    }

    public static String getQualifiedName(String string) {
        return Connections.ConnectionKey.createConnectionKey((String)"IdeConnections", (String)string).getQualifiedName();
    }
}

