/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.capture;

import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.CaptureWorker;
import oracle.dbtools.migration.capture.Capturer;
import oracle.dbtools.migration.capture.OnlineCapturer;
import oracle.dbtools.migration.capture.QueryCapture;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;

public class OnlineCaptureWorker
extends CaptureWorker {
    private OnlineCapturer m_onlineCapturer;

    public OnlineCaptureWorker(OnlineCapturer onlineCapturer, String string, String string2) {
        this(onlineCapturer, string, string2, null);
    }

    public OnlineCaptureWorker(OnlineCapturer onlineCapturer, String string, String string2, MigrationObjectFilterList migrationObjectFilterList) {
        super(string, string2, migrationObjectFilterList);
        this.m_onlineCapturer = onlineCapturer;
    }

    @Override
    protected void capturePerCatalogImpl(String string, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        String string2 = this.m_onlineCapturer.getCaptureQueries().getQueryForType(string, migrationObjectFilter);
        if (string2 != null) {
            try {
                QueryCapture.doTypeCapture(string2, string, this.m_onlineCapturer.getSourceConnection(), this.getStorer(), this.m_context);
            }
            catch (SQLException sQLException) {
                throw new CaptureException(sQLException);
            }
        } else {
            this.m_onlineCapturer.captureObjects(string, this.m_context, migrationObjectFilter);
        }
    }

    @Override
    protected void captureCatalogImpl(MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        String string = this.m_onlineCapturer.getCaptureQueries().getQueryForType("MD_CATALOGS", migrationObjectFilter);
        if (string != null) {
            try {
                QueryCapture.doCatalogCapture(string, this.m_onlineCapturer.getSourceConnection(), this.getStorer(), this.m_context);
            }
            catch (SQLException sQLException) {
                throw new CaptureException(sQLException);
            }
        } else {
            this.m_onlineCapturer.captureObjects("MD_CATALOGS", this.m_context, migrationObjectFilter);
        }
    }

    @Override
    protected void captureSchemaImpl(MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        String string = this.m_onlineCapturer.getCaptureQueries().getQueryForType("MD_SCHEMAS", migrationObjectFilter);
        if (string != null) {
            try {
                QueryCapture.doSchemaCapture(string, this.m_onlineCapturer.getSourceConnection(), this.getStorer(), this.m_context);
            }
            catch (SQLException sQLException) {
                throw new CaptureException(sQLException);
            }
        } else {
            this.m_onlineCapturer.captureObjects("MD_SCHEMAS", this.m_context, migrationObjectFilter);
        }
    }

    @Override
    protected void captureTableImpl(MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        String string = this.m_onlineCapturer.getCaptureQueries().getQueryForType("MD_TABLES", migrationObjectFilter);
        if (string != null) {
            try {
                QueryCapture.doTableCapture(string, this.m_onlineCapturer.getSourceConnection(), this.getStorer(), this.m_context);
            }
            catch (SQLException sQLException) {
                throw new CaptureException(sQLException);
            }
        } else {
            this.m_onlineCapturer.captureObjects("MD_TABLES", this.m_context, migrationObjectFilter);
        }
    }

    @Override
    protected void capturePerSchemaImpl(String string, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        String string2 = this.m_onlineCapturer.getCaptureQueries().getQueryForType(string, migrationObjectFilter);
        if (string2 != null) {
            try {
                QueryCapture.doTypeCapture(string2, string, this.m_onlineCapturer.getSourceConnection(), this.getStorer(), this.m_context);
            }
            catch (SQLException sQLException) {
                throw new CaptureException(sQLException);
            }
        } else {
            this.m_onlineCapturer.captureObjects(string, this.m_context, migrationObjectFilter);
        }
    }

    @Override
    protected void capturePerTableImpl(String string, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        String string2 = this.m_onlineCapturer.getCaptureQueries().getQueryForType(string, migrationObjectFilter);
        if (string2 != null) {
            try {
                QueryCapture.doTypeCapture(string2, string, this.m_onlineCapturer.getSourceConnection(), this.getStorer(), this.m_context);
            }
            catch (SQLException sQLException) {
                throw new CaptureException(sQLException);
            }
        } else {
            this.m_onlineCapturer.captureObjects(string, this.m_context, migrationObjectFilter);
        }
    }

    @Override
    protected void capturePerViewImpl(String string, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        String string2 = this.m_onlineCapturer.getCaptureQueries().getQueryForType(string, migrationObjectFilter);
        if (string2 != null) {
            try {
                QueryCapture.doTypeCapture(string2, string, this.m_onlineCapturer.getSourceConnection(), this.getStorer(), this.m_context);
            }
            catch (SQLException sQLException) {
                throw new CaptureException(sQLException);
            }
        } else {
            this.m_onlineCapturer.captureObjects(string, this.m_context, migrationObjectFilter);
        }
    }

    @Override
    protected Capturer getCapturer() {
        return this.m_onlineCapturer;
    }

    @Override
    protected void captureSynonymImpl(MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        String string = this.m_onlineCapturer.getCaptureQueries().getQueryForType("MD_SYNONYMS", migrationObjectFilter);
        if (string != null) {
            try {
                QueryCapture.doTableCapture(string, this.m_onlineCapturer.getSourceConnection(), this.getStorer(), this.m_context);
            }
            catch (SQLException sQLException) {
                throw new CaptureException(sQLException);
            }
        } else {
            this.m_onlineCapturer.captureObjects("MD_SYNONYMS", this.m_context, migrationObjectFilter);
        }
    }
}

