/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import oracle.dbtools.metadata.persistence.BlobHelper;

public class PrepareBlobHelper {
    public static final int OVERSIZE = 20000;
    private byte[] m_permanentByteStore = null;
    private File m_fileStore = null;
    private BufferedOutputStream m_bufferedOutputStream = null;
    private int m_totalLength = 0;
    private boolean m_inputStreamIsNull = false;
    private int m_overSize = 20000;

    public PrepareBlobHelper() {
    }

    public PrepareBlobHelper(int n) {
        this.m_overSize = n;
    }

    public void setInputStream(InputStream inputStream) throws IOException {
        int n = 0;
        if (inputStream != null) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            if (this.m_permanentByteStore == null) {
                this.m_permanentByteStore = new byte[this.m_overSize];
            }
            boolean bl = false;
            int n2 = 0;
            while (!bl) {
                n2 = bufferedInputStream.read(this.m_permanentByteStore, n, this.m_overSize - n);
                if (n2 == -1 || n2 + n == this.m_overSize) {
                    bl = true;
                    continue;
                }
                n += n2;
            }
            if (n2 == -1) {
                this.m_totalLength = n;
                return;
            }
            this.m_fileStore = File.createTempFile("Blobstore", ".tmp");
            this.m_fileStore.deleteOnExit();
            this.m_bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.m_fileStore));
            this.m_bufferedOutputStream.write(this.m_permanentByteStore, 0, this.m_overSize);
            this.m_totalLength = this.m_overSize;
            while (true) {
                bl = false;
                n = 0;
                while (!bl) {
                    n2 = bufferedInputStream.read(this.m_permanentByteStore, n, this.m_overSize - n);
                    if (n2 == -1 || n2 + n == this.m_overSize) {
                        bl = true;
                        continue;
                    }
                    n += n2;
                }
                if (n2 == -1) {
                    this.m_totalLength += n;
                    this.m_bufferedOutputStream.write(this.m_permanentByteStore, 0, n);
                    return;
                }
                this.m_totalLength += this.m_overSize;
                this.m_bufferedOutputStream.write(this.m_permanentByteStore, 0, this.m_overSize);
            }
        }
        this.m_inputStreamIsNull = true;
    }

    public BlobHelper getBlobHelper() throws IOException {
        if (this.m_fileStore != null && this.m_bufferedOutputStream != null) {
            this.m_bufferedOutputStream.close();
        }
        if (this.m_inputStreamIsNull) {
            return null;
        }
        if (this.m_fileStore == null) {
            return new BlobHelper(new ByteArrayInputStream(this.m_permanentByteStore, 0, this.m_totalLength), this.m_totalLength);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.m_fileStore));
        return new BlobHelper(bufferedInputStream, this.m_totalLength);
    }

    public void close() throws IOException {
        if (this.m_fileStore != null) {
            this.m_bufferedOutputStream.close();
        }
        if (this.m_fileStore != null) {
            this.m_fileStore.delete();
        }
    }
}

