/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdIndexDetail
extends PersistableObject {
    public static final String TABLE_NAME = "MD_INDEX_DETAILS";
    public static final String COLNAME_INDEX_ID_FK = "INDEX_ID_FK";
    public static final String COLNAME_COLUMN_ID_FK = "COLUMN_ID_FK";
    public static final String COLNAME_INDEX_PORTION = "INDEX_PORTION";
    public static final String COLNAME_DETAIL_ORDER = "DETAIL_ORDER";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";

    public MdIndexDetail(DBObjectId dBObjectId, DBObjectId dBObjectId2, Integer n) {
        this.setIndexId(dBObjectId);
        this.setColumnId(dBObjectId2);
        this.setDetailOrder(n);
    }

    public static MdIndexDetail getExistingInstance(DBObjectId dBObjectId) {
        MdIndexDetail mdIndexDetail = new MdIndexDetail();
        mdIndexDetail.setKey(dBObjectId);
        return mdIndexDetail;
    }

    private MdIndexDetail() {
    }

    public static MdIndexDetail retrieveExistingInstance(PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException {
        MdIndexDetail mdIndexDetail = MdIndexDetail.getExistingInstance(dBObjectId);
        mdIndexDetail.retrieve(persistenceManager);
        return mdIndexDetail;
    }

    protected void setIndexId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_INDEX_ID_FK, "DBOBJECTID", false);
        field.setValue(dBObjectId);
        this.setField(field);
    }

    protected void setColumnId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_COLUMN_ID_FK, "DBOBJECTID", false);
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setIndexPortion(Integer n) {
        Field field = new Field(COLNAME_INDEX_PORTION, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    protected void setDetailOrder(Integer n) {
        Field field = new Field(COLNAME_DETAIL_ORDER, "INTEGER", false);
        field.setValue(n);
        this.setField(field);
    }

    public void setSecurityGroupId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setCreatedOn(Date date) {
        Field field = new Field(COLNAME_CREATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setCreatedBy(String string) {
        Field field = new Field(COLNAME_CREATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setLastUpdatedOn(Date date) {
        Field field = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setLastUpdatedBy(String string) {
        Field field = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public DBObjectId getIndexId() {
        Field field = this.getField(COLNAME_INDEX_ID_FK);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public DBObjectId getColumnId() {
        Field field = this.getField(COLNAME_COLUMN_ID_FK);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public Integer getIndexPortion() {
        Field field = this.getField(COLNAME_INDEX_PORTION);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public Integer getDetailOrder() {
        Field field = this.getField(COLNAME_DETAIL_ORDER);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public DBObjectId getSecurityGroupId() {
        Field field = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field field = this.getField(COLNAME_CREATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getCreatedBy() {
        Field field = this.getField(COLNAME_CREATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Date getLastUpdatedOn() {
        Field field = this.getField(COLNAME_LAST_UPDATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getLastUpdatedBy() {
        Field field = this.getField(COLNAME_LAST_UPDATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public void retrieve(PersistenceManager persistenceManager) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet closeableResultSet = this.issueRetrieveQuery(persistenceManager);
        ResultSet resultSet = closeableResultSet.getResultSet();
        try {
            this.setIndexId(new DBObjectId(resultSet.getLong(COLNAME_INDEX_ID_FK)));
            this.setColumnId(new DBObjectId(resultSet.getLong(COLNAME_COLUMN_ID_FK)));
            Object object = resultSet.getInt(COLNAME_INDEX_PORTION);
            if (resultSet.wasNull()) {
                this.setIndexPortion(null);
            } else {
                this.setIndexPortion((Integer)object);
            }
            this.setDetailOrder(resultSet.getInt(COLNAME_DETAIL_ORDER));
            object = new DBObjectId(resultSet.getLong(COLNAME_SECURITY_GROUP_ID));
            if (resultSet.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)object);
            }
            object = resultSet.getDate(COLNAME_CREATED_ON);
            if (resultSet.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_CREATED_BY);
            if (resultSet.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)object);
            }
            object = resultSet.getDate(COLNAME_LAST_UPDATED_ON);
            if (resultSet.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_LAST_UPDATED_BY);
            if (resultSet.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)object);
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            closeableResultSet.close();
        }
        this.retrieveAdditionalProperties(persistenceManager);
        this.clearUpdatedFields();
    }

    @Override
    public String getContainerFieldName() {
        return COLNAME_INDEX_ID_FK;
    }

    @Override
    public DBObjectId getContainerId() {
        return this.getIndexId();
    }

    @Override
    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

