/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.PersistableObjectIterator;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class ForeignKeyConstraintsIterator
extends PersistableObjectIterator {
    private static final String QUERY_GET_FKS_FOR_SCHEMA = "SELECT ID FROM MD_CONSTRAINTS WHERE CONSTRAINT_TYPE = 'FOREIGN KEY' aND TABLE_ID_FK IN (SELECT TABLE_ID FROM MGV_ALL_TABLES WHERE SCHEMA_ID = ?)";
    private PreparedStatement m_statement;

    public ForeignKeyConstraintsIterator(PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException {
        super(MdConstraint.class, persistenceManager);
        try {
            this.m_statement = persistenceManager.getPreparedStatement(QUERY_GET_FKS_FOR_SCHEMA);
            this.m_statement.setLong(1, dBObjectId.getId());
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
    }

    @Override
    protected PreparedStatement getPreparedStatement() throws SQLException {
        return this.m_statement;
    }
}

