/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.util;

import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XmlPullUtil {
    public static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";

    private XmlPullUtil() {
    }

    public static String getAttributeValue(XmlPullParser xmlPullParser, String string) {
        return xmlPullParser.getAttributeValue("", string);
    }

    public static String getPITarget(XmlPullParser xmlPullParser) throws IllegalStateException {
        int n;
        try {
            n = xmlPullParser.getEventType();
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new IllegalStateException("could not determine parser state: " + xmlPullParserException + xmlPullParser.getPositionDescription());
        }
        if (n != 8) {
            throw new IllegalStateException("parser must be on processing instruction and not " + XmlPullParser.TYPES[n] + xmlPullParser.getPositionDescription());
        }
        String string = xmlPullParser.getText();
        for (int i = 0; i < string.length(); ++i) {
            if (!XmlPullUtil.isS(string.charAt(i))) continue;
            return string.substring(0, i);
        }
        return string;
    }

    public static String getPIData(XmlPullParser xmlPullParser) throws IllegalStateException {
        int n;
        try {
            n = xmlPullParser.getEventType();
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new IllegalStateException("could not determine parser state: " + xmlPullParserException + xmlPullParser.getPositionDescription());
        }
        if (n != 8) {
            throw new IllegalStateException("parser must be on processing instruction and not " + XmlPullParser.TYPES[n] + xmlPullParser.getPositionDescription());
        }
        String string = xmlPullParser.getText();
        int n2 = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (XmlPullUtil.isS(string.charAt(i))) {
                n2 = i;
                continue;
            }
            if (n2 <= 0) continue;
            return string.substring(i);
        }
        return "";
    }

    private static boolean isS(char c) {
        return c == ' ' || c == '\n' || c == '\r' || c == '\t';
    }

    public static void skipSubTree(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        xmlPullParser.require(2, null, null);
        int n = 1;
        while (n > 0) {
            int n2 = xmlPullParser.next();
            if (n2 == 3) {
                --n;
                continue;
            }
            if (n2 != 2) continue;
            ++n;
        }
    }

    public static void nextStartTag(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        if (xmlPullParser.nextTag() != 2) {
            throw new XmlPullParserException("expected START_TAG and not " + xmlPullParser.getPositionDescription());
        }
    }

    public static void nextStartTag(XmlPullParser xmlPullParser, String string) throws XmlPullParserException, IOException {
        xmlPullParser.nextTag();
        xmlPullParser.require(2, null, string);
    }

    public static void nextStartTag(XmlPullParser xmlPullParser, String string, String string2) throws XmlPullParserException, IOException {
        xmlPullParser.nextTag();
        xmlPullParser.require(2, string, string2);
    }

    public static void nextEndTag(XmlPullParser xmlPullParser, String string, String string2) throws XmlPullParserException, IOException {
        xmlPullParser.nextTag();
        xmlPullParser.require(3, string, string2);
    }

    public static String nextText(XmlPullParser xmlPullParser, String string, String string2) throws IOException, XmlPullParserException {
        if (string2 == null) {
            throw new XmlPullParserException("name for element can not be null");
        }
        xmlPullParser.require(2, string, string2);
        return xmlPullParser.nextText();
    }

    public static String getRequiredAttributeValue(XmlPullParser xmlPullParser, String string, String string2) throws IOException, XmlPullParserException {
        String string3 = xmlPullParser.getAttributeValue(string, string2);
        if (string3 == null) {
            throw new XmlPullParserException("required attribute " + string2 + " is not present");
        }
        return string3;
    }

    public static void nextEndTag(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        if (xmlPullParser.nextTag() != 3) {
            throw new XmlPullParserException("expected END_TAG and not" + xmlPullParser.getPositionDescription());
        }
    }

    public static boolean matches(XmlPullParser xmlPullParser, int n, String string, String string2) throws XmlPullParserException {
        boolean bl = !(n != xmlPullParser.getEventType() || string != null && !string.equals(xmlPullParser.getNamespace()) || string2 != null && !string2.equals(xmlPullParser.getName()));
        return bl;
    }

    public static void writeSimpleElement(XmlSerializer xmlSerializer, String string, String string2, String string3) throws IOException, XmlPullParserException {
        if (string2 == null) {
            throw new XmlPullParserException("name for element can not be null");
        }
        xmlSerializer.startTag(string, string2);
        if (string3 == null) {
            xmlSerializer.attribute(XSI_NS, "nil", "true");
        } else {
            xmlSerializer.text(string3);
        }
        xmlSerializer.endTag(string, string2);
    }
}

