/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.samples.xpath;

import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.xmlpull.v1.builder.XmlDocument;
import org.xmlpull.v1.builder.XmlElement;
import org.xmlpull.v1.builder.XmlInfosetBuilder;
import org.xmlpull.v1.builder.xpath.Xb1XPath;
import org.xmlpull.v1.builder.xpath.jaxen.JaxenException;

public class XB1XPathTest
extends TestCase {
    private static final String BASIC_XML = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n\n<foo>\n    <bar>\n        <baz/>\n        <cheese/>\n        <baz/>\n        <cheese/>\n        <baz/>\n    </bar>\n</foo>";

    public static void main(String[] stringArray) {
        TestRunner.run((Test)new TestSuite(XB1XPathTest.class));
    }

    public XB1XPathTest(String string) {
        super(string);
    }

    public void testConstruction() {
        try {
            Xb1XPath xb1XPath = new Xb1XPath("/foo/bar/baz");
        }
        catch (JaxenException jaxenException) {
            XB1XPathTest.fail((String)jaxenException.getMessage());
        }
    }

    public void testSelection() throws Exception {
        Xb1XPath xb1XPath = new Xb1XPath("/foo/bar/baz");
        XmlInfosetBuilder xmlInfosetBuilder = XmlInfosetBuilder.newInstance();
        XmlDocument xmlDocument = xmlInfosetBuilder.parseReader(new StringReader(BASIC_XML));
        List list = xb1XPath.selectNodes(xmlDocument);
        XB1XPathTest.assertEquals((int)3, (int)list.size());
        Iterator iterator = list.iterator();
        XB1XPathTest.assertEquals((String)"baz", (String)((XmlElement)iterator.next()).getName());
        XB1XPathTest.assertEquals((String)"baz", (String)((XmlElement)iterator.next()).getName());
        XB1XPathTest.assertEquals((String)"baz", (String)((XmlElement)iterator.next()).getName());
        XB1XPathTest.assertTrue((!iterator.hasNext() ? 1 : 0) != 0);
    }
}

