/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.samples;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public abstract class XMLRPCDecoder {
    private static final Class[] Classes = new Class[]{FaultDecoder.class, MethodDecoder.class, ParametersDecoder.class, ArrayDecoder.class, StructureDecoder.class, ValueDecoder.class, IntegerDecoder.class, BooleanDecoder.class, StringDecoder.class, DoubleDecoder.class, DateDecoder.class, Base64Decoder.class};
    private static final Map _decoders = new HashMap();

    protected XMLRPCDecoder() {
    }

    private static Map decoders() {
        return _decoders;
    }

    public static Object decode(Reader reader) throws Exception {
        if (reader != null) {
            Map map = XMLRPCDecoder.decoders();
            XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
            XmlPullParser xmlPullParser = xmlPullParserFactory.newPullParser();
            xmlPullParser.setInput(reader);
            return XMLRPCDecoder.decode(xmlPullParser);
        }
        throw new IllegalArgumentException("XMLRPCDecoder.decode: null reader.");
    }

    private static XMLRPCDecoder decoderWithName(String string) {
        if (string != null) {
            return (XMLRPCDecoder)XMLRPCDecoder.decoders().get(string.toUpperCase());
        }
        throw new IllegalArgumentException("XMLRPCDecoder.decoderWithName: null name.");
    }

    private static Object decode(XmlPullParser xmlPullParser) throws Exception {
        if (xmlPullParser != null) {
            int n = xmlPullParser.getEventType();
            while (n != 1) {
                if (n == 2) {
                    String string = xmlPullParser.getName();
                    XMLRPCDecoder xMLRPCDecoder = XMLRPCDecoder.decoderWithName(string);
                    if (xMLRPCDecoder != null) {
                        return xMLRPCDecoder.decodeWithParser(xmlPullParser);
                    }
                    n = xmlPullParser.next();
                    continue;
                }
                n = xmlPullParser.next();
            }
            return null;
        }
        throw new IllegalArgumentException("XMLRPCDecoder.decode: null reader.");
    }

    protected abstract String[] names();

    protected void register(Map map) {
        if (map != null) {
            String[] stringArray = this.names();
            if (stringArray != null) {
                for (String string : stringArray) {
                    map.put(string.toUpperCase(), this);
                }
                return;
            }
            throw new IllegalStateException("XMLRPCDecoder.register: null names.");
        }
        throw new IllegalArgumentException("XMLRPCDecoder.register: null map.");
    }

    protected abstract Object decodeWithParser(XmlPullParser var1) throws Exception;

    public static void main(String[] stringArray) {
        stringArray = new String[]{"http://www.oreillynet.com/meerkat/xml-rpc/server.php"};
        if (stringArray.length == 1) {
            System.out.println("Decoding \"" + stringArray[0] + "\"");
            try {
                URL uRL = new URL(stringArray[0]);
                byte[] byArray = "<methodCall><methodName>system.listMethods</methodName><params><param><value></value></param></params></methodCall>".getBytes();
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setDoInput(true);
                uRLConnection.setDoOutput(true);
                uRLConnection.setUseCaches(false);
                uRLConnection.setAllowUserInteraction(false);
                uRLConnection.setRequestProperty("Content-Type", "text/xml");
                uRLConnection.setRequestProperty("Content-Length", Integer.toString(byArray.length));
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(uRLConnection.getOutputStream());
                ((OutputStream)bufferedOutputStream).write(byArray);
                ((OutputStream)bufferedOutputStream).flush();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
                InputStreamReader inputStreamReader = new InputStreamReader(bufferedInputStream);
                Object object = XMLRPCDecoder.decode(inputStreamReader);
                System.out.println("anObject: " + object.getClass());
                System.out.println("anObject: " + object);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
            return;
        }
        System.out.println("XMLRPCDecoder maps an XML-RPC document into its Java equivalent.");
        System.out.println("This example will send a canned 'system.listMethods' to the target url.");
        System.out.println("Usage: <url>");
        System.out.println("Example: \"http://www.oreillynet.com/meerkat/xml-rpc/server.php\"");
    }

    static {
        for (Class clazz : Classes) {
            try {
                XMLRPCDecoder xMLRPCDecoder = (XMLRPCDecoder)clazz.newInstance();
                xMLRPCDecoder.register(_decoders);
            }
            catch (Exception exception) {
                throw new RuntimeException("XMLRPCDecoder.decoders: " + exception);
            }
        }
    }

    public static final class Base64 {
        private static char[] alphabet;
        private static byte[] codes;

        public static byte[] decode(byte[] byArray) {
            int n = (byArray.length + 3) / 4 * 3;
            if (byArray.length > 0 && byArray[byArray.length - 1] == 61) {
                --n;
            }
            if (byArray.length > 1 && byArray[byArray.length - 2] == 61) {
                --n;
            }
            byte[] byArray2 = new byte[n];
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < byArray.length; ++i) {
                byte by = codes[byArray[i] & 0xFF];
                if (by < 0) continue;
                n3 <<= 6;
                n3 |= by;
                if ((n2 += 6) < 8) continue;
                byArray2[n4++] = (byte)(n3 >> (n2 -= 8) & 0xFF);
            }
            if (n4 != byArray2.length) {
                throw new RuntimeException("Error decoding BASE64 element: Miscalculated data length.");
            }
            return byArray2;
        }

        static {
            int n;
            alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
            codes = new byte[256];
            for (n = 0; n < 256; ++n) {
                Base64.codes[n] = -1;
            }
            for (n = 65; n <= 90; ++n) {
                Base64.codes[n] = (byte)(n - 65);
            }
            for (n = 97; n <= 122; ++n) {
                Base64.codes[n] = (byte)(26 + n - 97);
            }
            for (n = 48; n <= 57; ++n) {
                Base64.codes[n] = (byte)(52 + n - 48);
            }
            Base64.codes[43] = 62;
            Base64.codes[47] = 63;
        }
    }

    private static final class Base64Decoder
    extends XMLRPCDecoder {
        private static final String Name = "base64";
        private static final String[] Names = new String[]{"base64"};

        protected Base64Decoder() {
        }

        @Override
        protected String[] names() {
            return Names;
        }

        @Override
        protected Object decodeWithParser(XmlPullParser xmlPullParser) throws Exception {
            if (xmlPullParser != null) {
                xmlPullParser.require(2, null, Name);
                String string = xmlPullParser.nextText();
                byte[] byArray = null;
                if (string != null) {
                    try {
                        byArray = Base64.decode(string.getBytes());
                    }
                    catch (Exception exception) {
                        System.err.println(byArray);
                    }
                }
                xmlPullParser.require(3, null, Name);
                xmlPullParser.nextTag();
                return byArray;
            }
            throw new IllegalArgumentException("XMLRPCDecoder.Base64Decoder.decodeWithParser: null parser.");
        }
    }

    private static final class DateDecoder
    extends XMLRPCDecoder {
        private static final String Name = "dateTime.iso8601";
        private static final String[] Names = new String[]{"dateTime.iso8601"};
        private static final String Format = "yyyyMMdd'T'HH:mm:ss";

        protected DateDecoder() {
        }

        @Override
        protected String[] names() {
            return Names;
        }

        @Override
        protected Object decodeWithParser(XmlPullParser xmlPullParser) throws Exception {
            if (xmlPullParser != null) {
                xmlPullParser.require(2, null, Name);
                String string = xmlPullParser.nextText();
                Date date = null;
                if (string != null) {
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(Format);
                        date = simpleDateFormat.parse(string);
                    }
                    catch (Exception exception) {
                        System.err.println(exception);
                    }
                }
                xmlPullParser.require(3, null, Name);
                xmlPullParser.nextTag();
                return date;
            }
            throw new IllegalArgumentException("XMLRPCDecoder.DateDecoder.decodeWithParser: null parser.");
        }
    }

    private static final class StringDecoder
    extends XMLRPCDecoder {
        private static final String Name = "string";
        private static final String[] Names = new String[]{"string"};

        protected StringDecoder() {
        }

        @Override
        protected String[] names() {
            return Names;
        }

        @Override
        protected Object decodeWithParser(XmlPullParser xmlPullParser) throws Exception {
            if (xmlPullParser != null) {
                xmlPullParser.require(2, null, Name);
                String string = xmlPullParser.nextText();
                xmlPullParser.require(3, null, Name);
                xmlPullParser.next();
                if (string != null && string.length() == 0) {
                    string = null;
                }
                return string;
            }
            throw new IllegalArgumentException("XMLRPCDecoder.StringDecoder.decodeWithParser: null parser.");
        }
    }

    private static final class DoubleDecoder
    extends XMLRPCDecoder {
        private static final String Name = "double";
        private static final String[] Names = new String[]{"double"};

        protected DoubleDecoder() {
        }

        @Override
        protected String[] names() {
            return Names;
        }

        @Override
        protected Object decodeWithParser(XmlPullParser xmlPullParser) throws Exception {
            if (xmlPullParser != null) {
                xmlPullParser.require(2, null, Name);
                String string = xmlPullParser.nextText();
                Double d = null;
                if (string != null) {
                    try {
                        d = new Double(string);
                    }
                    catch (Exception exception) {
                        System.err.println(exception);
                    }
                }
                xmlPullParser.require(3, null, Name);
                xmlPullParser.nextTag();
                return d;
            }
            throw new IllegalArgumentException("XMLRPCDecoder.DoubleDecoder.decodeWithParser: null parser.");
        }
    }

    private static final class BooleanDecoder
    extends XMLRPCDecoder {
        private static final String Name = "boolean";
        private static final String[] Names = new String[]{"boolean"};
        private static final String False = "0";

        protected BooleanDecoder() {
        }

        @Override
        protected String[] names() {
            return Names;
        }

        @Override
        protected Object decodeWithParser(XmlPullParser xmlPullParser) throws Exception {
            if (xmlPullParser != null) {
                xmlPullParser.require(2, null, Name);
                String string = xmlPullParser.nextText();
                Boolean bl = Boolean.TRUE;
                if (False.equals(string)) {
                    bl = Boolean.FALSE;
                }
                xmlPullParser.require(3, null, Name);
                xmlPullParser.next();
                return bl;
            }
            throw new IllegalArgumentException("XMLRPCDecoder.BooleanDecoder.decodeWithParser: null parser.");
        }
    }

    private static final class IntegerDecoder
    extends XMLRPCDecoder {
        private static final String IntName = "int";
        private static final String I4Name = "i4";
        private static final String[] Names = new String[]{"int", "i4"};

        protected IntegerDecoder() {
        }

        @Override
        protected String[] names() {
            return Names;
        }

        @Override
        protected Object decodeWithParser(XmlPullParser xmlPullParser) throws Exception {
            if (xmlPullParser != null) {
                String string = xmlPullParser.getName();
                xmlPullParser.require(2, null, string);
                String string2 = xmlPullParser.nextText();
                Integer n = null;
                if (string2 != null) {
                    try {
                        n = new Integer(string2);
                    }
                    catch (Exception exception) {
                        System.err.println(exception);
                    }
                }
                xmlPullParser.require(3, null, string);
                xmlPullParser.nextTag();
                return n;
            }
            throw new IllegalArgumentException("XMLRPCDecoder.IntegerDecoder.decodeWithParser: null parser.");
        }
    }

    private static final class ValueDecoder
    extends XMLRPCDecoder {
        private static final String Name = "value";
        private static final String[] Names = new String[]{"value"};

        protected ValueDecoder() {
        }

        @Override
        protected String[] names() {
            return Names;
        }

        @Override
        protected Object decodeWithParser(XmlPullParser xmlPullParser) throws Exception {
            if (xmlPullParser != null) {
                Object object = null;
                xmlPullParser.require(2, null, Name);
                xmlPullParser.next();
                object = xmlPullParser.getEventType() == 3 ? "" : XMLRPCDecoder.decode(xmlPullParser);
                xmlPullParser.require(3, null, Name);
                xmlPullParser.nextTag();
                return object;
            }
            throw new IllegalArgumentException("XMLRPCDecoder.ValueDecoder.decodeWithParser: null parser.");
        }
    }

    private static final class StructureDecoder
    extends XMLRPCDecoder {
        private static final String Name = "struct";
        private static final String MemberName = "member";
        private static final String NameName = "name";
        private static final String[] Names = new String[]{"struct"};

        protected StructureDecoder() {
        }

        @Override
        protected String[] names() {
            return Names;
        }

        @Override
        protected Object decodeWithParser(XmlPullParser xmlPullParser) throws Exception {
            if (xmlPullParser != null) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                xmlPullParser.require(2, null, Name);
                xmlPullParser.nextTag();
                while (xmlPullParser.getEventType() != 1 && xmlPullParser.getEventType() == 2) {
                    String string = null;
                    Object object = null;
                    xmlPullParser.require(2, null, MemberName);
                    xmlPullParser.nextTag();
                    xmlPullParser.require(2, null, NameName);
                    string = xmlPullParser.nextText();
                    xmlPullParser.require(3, null, NameName);
                    object = XMLRPCDecoder.decode(xmlPullParser);
                    xmlPullParser.require(3, null, MemberName);
                    xmlPullParser.nextTag();
                    if (string == null || object == null) continue;
                    hashMap.put(string, object);
                }
                xmlPullParser.require(3, null, Name);
                xmlPullParser.nextTag();
                if (hashMap.isEmpty()) {
                    hashMap = null;
                }
                return hashMap;
            }
            throw new IllegalArgumentException("XMLRPCDecoder.StructureDecoder.decodeWithParser: null parser.");
        }
    }

    private static final class ArrayDecoder
    extends XMLRPCDecoder {
        private static final String Name = "array";
        private static final String DataName = "data";
        private static final String[] Names = new String[]{"array"};

        protected ArrayDecoder() {
        }

        @Override
        protected String[] names() {
            return Names;
        }

        @Override
        protected Object decodeWithParser(XmlPullParser xmlPullParser) throws Exception {
            if (xmlPullParser != null) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                xmlPullParser.require(2, null, Name);
                xmlPullParser.nextTag();
                xmlPullParser.require(2, null, DataName);
                xmlPullParser.nextTag();
                while (xmlPullParser.getEventType() != 1 && xmlPullParser.getEventType() == 2) {
                    Object object = XMLRPCDecoder.decode(xmlPullParser);
                    arrayList.add(object);
                }
                if (arrayList.isEmpty()) {
                    arrayList = null;
                }
                xmlPullParser.require(3, null, DataName);
                xmlPullParser.nextTag();
                xmlPullParser.require(3, null, Name);
                xmlPullParser.nextTag();
                return arrayList;
            }
            throw new IllegalArgumentException("XMLRPCDecoder.ArrayDecoder.decodeWithParser: null parser.");
        }
    }

    private static final class ParametersDecoder
    extends XMLRPCDecoder {
        private static final String Name = "params";
        private static final String ParamName = "param";
        private static final String[] Names = new String[]{"params"};

        protected ParametersDecoder() {
        }

        @Override
        protected String[] names() {
            return Names;
        }

        @Override
        protected Object decodeWithParser(XmlPullParser xmlPullParser) throws Exception {
            if (xmlPullParser != null) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                xmlPullParser.require(2, null, Name);
                xmlPullParser.nextTag();
                while (xmlPullParser.getEventType() != 1 && xmlPullParser.getEventType() == 2) {
                    xmlPullParser.require(2, null, ParamName);
                    xmlPullParser.nextTag();
                    arrayList.add(XMLRPCDecoder.decode(xmlPullParser));
                    xmlPullParser.require(3, null, ParamName);
                    xmlPullParser.nextTag();
                }
                xmlPullParser.require(3, null, Name);
                xmlPullParser.nextTag();
                if (arrayList.isEmpty()) {
                    arrayList = null;
                }
                return arrayList;
            }
            throw new IllegalArgumentException("XMLRPCDecoder.ParametersDecoder.decodeWithParser: null parser.");
        }
    }

    private static final class MethodDecoder
    extends XMLRPCDecoder {
        private static final String Name = "methodCall";
        private static final String[] Names = new String[]{"methodCall"};

        protected MethodDecoder() {
        }

        @Override
        protected String[] names() {
            return Names;
        }

        @Override
        protected Object decodeWithParser(XmlPullParser xmlPullParser) throws Exception {
            if (xmlPullParser != null) {
                xmlPullParser.require(2, null, Name);
                xmlPullParser.nextTag();
                String string = xmlPullParser.nextText();
                Collection collection = (Collection)XMLRPCDecoder.decode(xmlPullParser);
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("methodName", string);
                hashMap.put("parameters", collection);
                if (xmlPullParser.getEventType() != 1) {
                    xmlPullParser.require(3, null, Name);
                    xmlPullParser.next();
                }
                return hashMap;
            }
            throw new IllegalArgumentException("XMLRPCDecoder.MethodDecoder.decodeWithParser: null parser.");
        }
    }

    private static final class FaultDecoder
    extends XMLRPCDecoder {
        private static final String Name = "fault";
        private static final String[] Names = new String[]{"fault"};
        private static final String FaultStringKey = "faultString";
        private static final String FaultCodeKey = "faultCode";

        protected FaultDecoder() {
        }

        @Override
        protected String[] names() {
            return Names;
        }

        @Override
        protected Object decodeWithParser(XmlPullParser xmlPullParser) throws Exception {
            if (xmlPullParser != null) {
                xmlPullParser.require(2, null, Name);
                xmlPullParser.nextTag();
                Map map = (Map)XMLRPCDecoder.decode(xmlPullParser);
                RuntimeException runtimeException = null;
                if (map != null) {
                    String string = (String)map.get(FaultStringKey);
                    Number number = (Number)map.get(FaultCodeKey);
                    runtimeException = new RuntimeException(string + "(" + number + ")");
                }
                xmlPullParser.require(3, null, Name);
                xmlPullParser.nextTag();
                return runtimeException;
            }
            throw new IllegalArgumentException("XMLRPCDecoder.FaultDecoder.decodeWithParser: null parser.");
        }
    }
}

